
#
# Control file for  makes with cfront-based C++
#


#
# If this file gets included first, we want a default rule since this
# file defines some rules.  If it weren't here, then on of the other
# rules defined in this file would get invoked if make was called
# without a specific rule.
#
firstrule: all


#
# The platform name can be anything you want it to be
#
YACLPLATFORM = sparc


#
# Processors
#
CC     = CC
RANLIB = echo


#
# Processor options:
#
# PTALL=-ptall
PTALL  = -pta
PTDUMP = -ptd
#DEBUG = -g


#
# Various path names: change as necessary
#
X11INC    = -I$(OPENWINHOME)/include
X11LIB    = -L$(OPENWINHOME)/lib
MOTIFINC  = -I/usr/dt/include
MOTIFLIB  = -L/usr/dt/lib
MOTIFLIBS = -lXm -lXmu -lXt -lX11 -lsocket -lnsl

DEFINES   = -D__UNIX__ -D__X_MOTIF__ -D__CFRONT__


#
# -------------- Should not need to change anything below -----------
#
YACLLIB = $(YACLPATH)/lib/$(YACLPLATFORM)
YACLINC = -I$(YACLPATH)
INCPATH = $(YACLINC) $(CPP_INC) $(X11INC) $(MOTIFINC)
LIBPATH = $(X11LIB) $(MOTIFLIB) -L$(YACLLIB)

#
# Component names
#
BASE     = base
IO       = io
MEMORY   = memory
UI       = ui

#
# Composite build options
#

##PTREP  = -ptr./ptrepository
CCOPTS = -c $(PTREP) $(DEBUG) $(INCPATH) $(DEFINES)
COPTS  = -c $(DEBUG) $(INCPATH) $(DEFINES)

LNKOPTS    = $(PTREP) $(DEBUG) $(INCPATH) $(DEFINES) $(LIBPATH)
MEMLIB     = -l$(MEMORY)
BASELNKLIB = -l$(IO) -l$(BASE) $(MEMLIB) -lm
UILNKLIB   = -l$(UI) $(MOTIFLIBS) $(BASELNKLIB)


#
# Define my new default suffix rules
#
.SUFFIXES:
.SUFFIXES: .cxx .c .o


#
# Rule for .cxx files
#
.cxx.o:
	$(CC) $(CCOPTS)  $*.cxx


#
# Rule for .c files
#
.c.o:
	cc $(COPTS) $*.c


#
# Base clean target
#
clean: .FoRcE
	@set $(CLEANDESCEND) > /dev/null; for i \
	do \
		cd $$i; \
		echo Cleaning `pwd`; \
		make -f cfr_sun.mak clean; \
		cd ..; \
		echo Returning to `pwd`; \
	done
	-rm -f *.o $(APPLICATIONS) $(LIBRARIES) $(CLEANFILES)
	-rm -rf ptrepository $(CLEANDIRS)


#
# Target to force another target to fire
#
.FoRcE:

