

# -------------------------------------------------------------------------
#                 Control file for Borland C++ make                       |
#--------------------------------------------------------------------------

.AUTODEPEND

#
# ---------------------- What platform do we want? -------------
#

# By default, develop for Windows:

YACLPLATFORM = WINDOWS

# But we may want something else:

!if $d(__OS2__) || $d(OS2)
YACLPLATFORM = OS2
!elif $d(WINDOWS) || $d(__MS_WINDOWS__)
YACLPLATFORM = WINDOWS
!elif $d(WIN32) || $d(__MS_WIN32__) || $(OS) == Windows_NT
YACLPLATFORM = WIN32
!elif $d(__DOS__) || $d(DOS)
YACLPLATFORM = DOS
!endif

# Do we want the 3d look using CTL3D? (Comment this out if you're compiling
# for Windows 95 or Windows NT 4.0.)
# USE_CTL3D    = -DUSE_CTL3D




#
# ---------------------- Path names ----------------------------
#

!if !$d(BCPATH)
!if $(YACLPLATFORM) == OS2
BCPATH      = d:\bcos2
!else
BCPATH      = d:\bc4
!endif
!endif

!if !$d(YACLPATH)
!error Please define the environment variable YACLPATH.
!endif


#
# ---------------------  Command names -------------------------
#

COPY    = copy
DELETE  = del
RENAME  = mv
SED     = sed
FIND    = find
AWK     = gawk
LIBR    = $(BCPATH)\bin\tlib
!if $(YACLPLATFORM) == WIN32
CC      = $(BCPATH)\bin\bcc32
MAKE    = $(BCPATH)\bin\make
LINK    = $(BCPATH)\bin\tlink32
RC      = brc32
RCFLAGS = -DWIN32
!else
CC      = $(BCPATH)\bin\bcc
LINK    = $(BCPATH)\bin\tlink
RC      = rc
RCFLAGS = -k
!if $(YACLPLATFORM) == WINDOWS || $(YACLPLATFORM) == DOS
MAKE    = $(BCPATH)\bin\maker
!else
MAKE    = $(BCPATH)\bin\make
!endif
!endif
UNZIP   = unzip
!if $(YACLPLATFORM) == DOS || $(YACLPLATFORM) == WINDOWS
ZIP     = zip386
!else
ZIP     = zip
!endif
!if $(YACLPLATFORM) == OS2
SH      = bash
!else
SH      = sh
!endif



# ------------- Should not need to change anything below this line --------


YACLLIB     = $(YACLPATH)\lib\$(YACLPLATFORM)
INCLUDE     = $(BCPATH)\INCLUDE;$(YACLPATH)
LIB         = $(BCPATH)\LIB;$(YACLLIB)


#
# ---------------------- YACL components --------------------
#

BASE      = base
MEMORY    = memory
IO        = io
STATIC    = staticob

BASELIB   = $(YACLLIB)\$(BASE).lib
IOLIB     = $(YACLLIB)\$(IO).lib
STATICLIB = $(YACLLIB)\$(STATIC).lib
UI        = ui
UILIB     = $(YACLLIB)\$(UI).lib




#
#  ---------------------------- Compile options ------------------------
#


# Without optimizing, the Map object file will be too big under
# Borland C++ 4.0. So we must optimize:
# OPTIMIZE  = -O1

MAKE_MAPFILE = -m -s
DONT_MAKE_MAPFILE = -x

# Yes, we want a map file:
# MAPFILE_OPT = $(MAKE_MAPFILE)
# No, we don't want a map file:
MAPFILE_OPT = $(DONT_MAKE_MAPFILE)

WARNINGS = -wbbf -weas -wamb -wamp -wdef -wnod -wstv -wuse -wcln \
-wucp -wpre
# -wsig is omitted, because we get lots of those warnings


!if !$d(NOINLINE)
INLINE  = -vi
!endif

!if $d(DEBUG)
DEBUG  = -v
INLINE =
!endif

!if $(YACLPLATFORM) == OS2
    C0OBJ    = c02
    C0OBJ_NW = c02
    CLIB     = c2mt os2
    MATH     = 
    EMU      =
    IMPORT   =
    CCOPTS   = -Pcxx -c -V -I$(INCLUDE) $(INLINE)
    LNKOPTS  = $(DEBUG) -c $(MAPFILE_OPT)
!elif $(YACLPLATFORM) == DOS
    C0OBJ    = c0l
    C0OBJ_NW = c0l
    CLIB     = cl
    MATH     = mathl
    EMU      = emu
    MODEL    = -ml
    DEFINE = -D__DOS__
    CCOPTS  = -Pcxx -c -3  $(DEFINE) $(WINOPTS) $(MODEL) \
    -I$(INCLUDE) $(INLINE)
    LNKOPTS = $(DEBUG) -L$(YACLLIB) $(WINLINK) -C -c $(MAPFILE_OPT) -Vt
!elif $(YACLPLATFORM) == WIN32
    WINOPTS  = 
    WINLINK  =
    C0OBJ_NW = c0x32
    C0OBJ    = c0w32
    CLIB     = cw32
    MATH     = 
    EMU      =
    IMPORT   = import32
    MODEL    =
!if $d(USE_CTL3D)
    THREED   = $(YACLLIB)\ctl3d32
!endif
    DEFINE = -D__MS_WIN32__
    CCOPTS  = -Pcxx -c -3  $(DEFINE) $(WINOPTS) $(MODEL) \
    -I$(INCLUDE) $(INLINE) $(USE_CTL3D)
    LNKOPTS = $(DEBUG) -L$(YACLLIB) $(WINLINK) -c $(MAPFILE_OPT) 
!else
!if $d(BUILD_DLL)
    WINOPTS  = -WD -Vf
!else
    WINOPTS  = -WS -Vf
!endif
    WINLINK  = -Twe -C
    C0OBJ_NW = c0wl
    C0OBJ    = c0wl
    CLIB     = cwl
    MATH     = mathwl
    EMU      =
    IMPORT   = import
    MODEL    = -ml
!if $d(USE_CTL3D)
    THREED   = $(YACLLIB)\ctl3d
!endif
    DEFINE = -D__MS_WINDOWS__ -DWINDOWS
    CCOPTS  = -dc -Pcxx -c -3  $(DEFINE) $(WINOPTS) $(MODEL) \
    -I$(INCLUDE) $(INLINE) $(USE_CTL3D)
    LNKOPTS = $(DEBUG) -L$(YACLLIB) $(WINLINK) -C -c $(MAPFILE_OPT) -Vt
!endif


!if $d(DEBUG)
CCOPTS = $(CCOPTS) -v -DDEBUG
!endif

LNKLIB  =  $(UI) $(IO) $(BASE) $(MEMORY) $(THREED) $(EMU)  $(MATH) \
$(IMPORT)  $(CLIB) 
BASELNKLIB  =  $(IO) $(BASE) $(MEMORY) $(EMU)  $(MATH) \
$(IMPORT)  $(CLIB) 


