

#ifndef _strdict_h_
#define _strdict_h_


#include "ui/strseq.h"
#include "base/sequence.h"


typedef  CL_Sequence<void*>     KeySeq;
typedef  CL_Sequence<CL_String> StrSeq;


class CL_EXPORT StringDictionary : public UI_StringSequence
{

  public:

	 StringDictionary ();

	 const CL_Sequence<void*>&  keys() const;
	 CL_Sequence<void*>&        keys();
	 void*                      key (const char* c) const;
	 void*&                     key (const char* c);
	 virtual bool Insert (const CL_String& o, void*, long index = -1);
	 virtual long InsertByRank (const CL_String& o, void*);
	 virtual long Add (const CL_String& o,void *);
	 virtual CL_String Remove (long i);
	 virtual CL_String ExtractLeftmost ();
	 virtual CL_String ExtractRightmost ();
	 virtual void               operator=  (const CL_Object& o);
	 virtual StrSeq&            operator=  (const StrSeq&);
	 virtual StringDictionary&  operator=  (const StringDictionary&);
	 virtual StrSeq&            operator+= (const StrSeq&);
	 virtual StringDictionary&  operator+= (const StringDictionary&);
	 virtual long Move (const CL_IntegerSet& s, StrSeq& target);
	 virtual long Move (const CL_IntegerSet& s, StringDictionary&  target);
	 virtual bool ChangeSize (long new_size);
	 virtual void MakeEmpty ();
	 virtual bool ShiftRightAt (long pos, long amount = 1);
	 virtual bool ShiftLeftAt (long pos, long amount = 1);
	 const char* ClassName() const {return "StringDictionary";};


protected:

	 bool BinarySearch (const CL_String& o, long& index) const;
	 virtual bool Sort (long pos, long len);
	 virtual bool IsSorted () const;

	 virtual bool Insert (const CL_String& o, long index = -1);
	 virtual long InsertByRank (const CL_String& o);
	 virtual long Add (const CL_String& o);

	 KeySeq Keys;
	 void*  Default;
};

#endif _strdict_h_

