

// ##########################################################################
// #                                                                        #
// #                             SelectableLabel                            #
// #                                                                        #
// #                            - Definitionen -                            #
// #                                                                        #
// ##########################################################################



#include"gui/SelLabel.h"
#include"ui/dsplsurf.h"



// **************************************************************************
// *                             OBJEKT-HANDLING                            *
// **************************************************************************



// ************
// Konstruktion
// ************


SelectableLabel :: SelectableLabel(UI_VObjCollection*  parent,
											  const UI_Rectangle& shape,
											  UI_ViewID           id
											 )
						: UI_Label(parent, shape, id)
{
  Selected = FALSE;
};


// ***********
// Destruktion
// ***********


SelectableLabel :: ~SelectableLabel()
{};


// **************************************************************************
// *                            EVENT-HANDLING                              *
// **************************************************************************



bool SelectableLabel :: Select()
{
  if (!Selected)
	{
	  Selected = TRUE;
	  Invalidate();
	};
  return UI_Label::Select();
};


bool SelectableLabel :: Unselect()
{
  if (Selected)
	{
	  Selected = FALSE;
	  Invalidate();
	};
  return UI_Label::Select();
};


void SelectableLabel :: ToggleSelection()
{
  if (Selected)
		 Unselect();
  else Select  ();
};


bool SelectableLabel :: isSelected() const
{
  return Selected;
};


bool SelectableLabel :: Paint(const UI_Rectangle& r)
{
  UI_Label::Paint(r);
  if (Selected)
	{
	  UI_RectangleStruct r = {0,0,_shape.Width(),_shape.Height()};
	  UI_DisplaySurface& sf = CreateDisplaySurface();
	  sf.InvertRectangle(r);
	  DestroyDisplaySurface();
	};
  return FALSE;
};


bool SelectableLabel :: _TitleChanged()
{
  bool res = UI_Label::_TitleChanged();
  Invalidate();
  return res;
};
