#ifndef _Pair_H
#define _Pair_H

#include"cl/bool.h"

template <class TypeX, class TypeY>
class Pair
{
  public:

	 Pair         ();
	 Pair         (const TypeX& ValueX, const TypeY& ValueY);
	 virtual bool initialize  (const TypeX& ValueX, const TypeY& ValueY);
	 bool         operator <  (const Pair&)  const;
	 bool         operator <= (const Pair&)  const;
	 bool         operator >  (const Pair&)  const;
	 bool         operator >= (const Pair&)  const;
	 bool         operator == (const Pair&)  const;
	 const TypeX& get_ValueX  () const;
	 const TypeY& get_ValueY  () const;
	 void         set_ValueX  (const TypeX&);
	 void         set_ValueY  (const TypeY&);
	 TypeY&       valueY      ();
	 TypeX&       valueX      ();

  protected:

	 TypeX   ValueX;
	 TypeY   ValueY;
};

#endif _Pair_H

#include"gui/pair.cpp"
