
// ##########################################################################
// #                                                                        #
// #                                     Pair                               #
// #                                                                        #
// ##########################################################################


#ifndef _Pair_CPP
#define _Pair_CPP

#include"gui/pair.h"


// **************************************************************************
// *                              PUBLIC-METHODEN                           *
// **************************************************************************



// *************
// Konstruktoren
// *************


template <class TypeX, class TypeY>
Pair<TypeX,TypeY> :: Pair       ()
{};


template <class TypeX, class TypeY>
Pair<TypeX,TypeY> :: Pair       (const TypeX& x, const TypeY& y)
{
  ValueX = x;
  ValueY = y;
};


// ***************
// Initialisierung
// ***************


template <class TypeX, class TypeY>
bool    Pair<TypeX,TypeY> :: initialize  (const TypeX& x, const TypeY& y)
{
  ValueX = x;
  ValueY = y;
  return TRUE;
};


// ***********************
// Attributszugriff lesend
// ***********************


template <class TypeX, class TypeY>
const TypeY&  Pair<TypeX,TypeY> :: get_ValueY    () const
{
  return ValueY;
};


template <class TypeX, class TypeY>
TypeY& Pair<TypeX,TypeY> :: valueY    ()
{
  return ValueY;
};


template <class TypeX, class TypeY>
const TypeX&  Pair<TypeX,TypeY> :: get_ValueX    () const
{
  return ValueX;
};


template <class TypeX, class TypeY>
TypeX&  Pair<TypeX,TypeY> :: valueX    ()
{
  return ValueX;
};


// ***************************
// Attributszugriff schreibend
// ***************************


template <class TypeX, class TypeY>
void    Pair<TypeX,TypeY> :: set_ValueY    (const TypeY& y)
{
  ValueY = y;
  return;
};


template <class TypeX, class TypeY>
void    Pair<TypeX,TypeY> :: set_ValueX    (const TypeX& x)
{
  ValueX = x;
};


// **********
// Operatoren
// **********


template <class TypeX, class TypeY>
bool    Pair<TypeX,TypeY> :: operator <  (const Pair& p) const
{
  if (  (ValueX <  p.get_ValueX())
	  || (ValueX == p.get_ValueX() && ValueY < p.get_ValueY())
	  )
		 return TRUE;
  else return FALSE;
};


template <class TypeX, class TypeY>
bool    Pair<TypeX,TypeY> :: operator <= (const Pair& p) const
{
  if (  (ValueX <  p.get_ValueX())
	  || (ValueX == p.get_ValueX() && ValueY <= p.get_ValueY())
	  )
		 return TRUE;
  else return FALSE;
};


template <class TypeX, class TypeY>
bool    Pair<TypeX,TypeY> :: operator >  (const Pair& p) const
{
  if (  (ValueX >  p.get_ValueX())
	  || (ValueX == p.get_ValueX() && ValueY > p.get_ValueY())
	  )
		 return TRUE;
  else return FALSE;
};


template <class TypeX, class TypeY>
bool    Pair<TypeX,TypeY> :: operator >= (const Pair& p) const
{
  if (  (ValueX >  p.get_ValueX())
	  || (ValueX == p.get_ValueX() && ValueY >= p.get_ValueY())
	  )
		 return TRUE;
  else return FALSE;
};


template <class TypeX, class TypeY>
bool    Pair<TypeX,TypeY> :: operator == (const Pair& p) const
{
  if (  ValueX == p.get_ValueX()
	  && ValueY == p.get_ValueY()
	  )
		 return TRUE;
  else return FALSE;
};



#endif _Pair_CPP
