
// ##########################################################################
// #                                                                        #
// #                                   Icon                                 #
// #                                                                        #
// #                            - Deklarationen -                           #
// #                                                                        #
// ##########################################################################


#ifndef _Icon_H
#define _Icon_H


#include"gui/icondsc.h"
#include"gui/sellabel.h"
#include"ui/composit.h"
#include"ui/menu.h"
#include"ui/bitmap.h"
#include"ui/vector.h"

// IDS:

#define ID_ICON     1600
#define ID_ICON_LBL 1601


class IconWindow;


class Icon : public UI_VObjCollection
{

  public:

	 Icon (UI_CompositeVObject*   parent,
			 const UI_Rectangle&    shape,
			 unsigned               lblhgt  = 20,
			 UI_ViewID              id      = -1,
			 const char*            bmpname = "",
			 const char*            title   = "",
			 UI_MenuItemDescriptor* mnudsc  = NULL
			);
	 Icon (IconWindow*            parent,
			 const UI_Vector&       vct,
			 unsigned               lblhgt  = 20,
			 UI_ViewID              id      = -1,
			 const char*            bmpname = "",
			 const char*            title   = "",
			 UI_MenuItemDescriptor* mnudsc  = NULL
			);
	 Icon (UI_CompositeVObject*   parent,
			 const IconDescriptor&  dsc
			);
	 Icon (IconWindow*            parent,
			 const IconDescriptor&  dsc
			);

	 virtual const char* ClassName() const { return "Icon";};
	 virtual CL_String&  Title();

	 UI_Bitmap&       bmp();
	 UI_Label*        lbl();
	 UI_PopupMenu*&   mnu();

	 virtual bool     Unselect();
	 virtual bool     Select  ();
	 virtual void     ToggleSelection();
	 bool             isSelected() const;
	 virtual void     sendEvent(UI_EventType);

	protected:


	 virtual          ~Icon ();
	 void             initialize(unsigned               lblhgt,
										  const char*            bmpname,
										  const char*            title,
										  UI_MenuItemDescriptor* mnudsc
										 );
	 virtual bool     MakeVisualElement();
	 virtual void     Initialize       ();
	 virtual bool     ButtonDown       (const UI_Point&, UI_MouseButton btn,
													bool shiftKey, bool ctrlKey);
	 virtual bool     KeyTyped         (char);
	 virtual bool     Paint            (const UI_Rectangle&);
	 UI_Bitmap        Bmp;
	 SelectableLabel* Lbl;
	 UI_PopupMenu*    Mnu;
};

#endif _Icon_H
