

// ##########################################################################
// #                                                                        #
// #                                  Icon                                  #
// #                                                                        #
// #                            - Definitionen -                            #
// #                                                                        #
// ##########################################################################



#include"gui/icon.h"
#include"gui/iconwin.h"
#include"gui/keydefs.h"
#include"gui/stdmsg.h"
#include"ui/dsplsurf.h"
#include"ui/applic.h"
#include"ui/cntroler.h"
#include"ui/event.h"



// **************************************************************************
// *                             OBJEKT-HANDLING                            *
// **************************************************************************



// ************
// Konstruktion
// ************


Icon :: Icon(IconWindow*            parent,
				 const UI_Vector&       vct,
				 unsigned               lblhgt,
				 UI_ViewID              id,
				 const char*            bmpname,
				 const char*            title,
				 UI_MenuItemDescriptor* mnudsc
				)
		: UI_VObjCollection(parent, UI_Rectangle(0,0,vct.X(),vct.Y()), id)
{
  initialize(lblhgt,bmpname,title,mnudsc);
  parent->append(this);
};


Icon :: Icon(UI_CompositeVObject*   parent,
				 const UI_Rectangle&    shape,
				 unsigned               lblhgt,
				 UI_ViewID              id,
				 const char*            bmpname,
				 const char*            title,
				 UI_MenuItemDescriptor* mnudsc
				)
		: UI_VObjCollection(parent, shape, id)
{
  initialize(lblhgt,bmpname,title,mnudsc);
};


Icon :: Icon(IconWindow*            parent,
				 const IconDescriptor&  dsc
				)
		: UI_VObjCollection(parent, dsc.Shape, dsc.Id)
{
  initialize(dsc.LblHght,dsc.Bmp,dsc.Title,dsc.Mnu);
  parent->append(this);
};


Icon :: Icon(UI_CompositeVObject*   parent,
				 const IconDescriptor&  dsc
				)
		: UI_VObjCollection(parent, dsc.Shape, dsc.Id)
{
  initialize(dsc.LblHght,dsc.Bmp,dsc.Title,dsc.Mnu);
};



// ***********
// Destruktion
// ***********


Icon :: ~Icon()
{};


// ***************
// Initialisierung
// ***************


void Icon :: initialize(unsigned               lblhgt,
								const char*            bmpname,
								const char*            title,
								UI_MenuItemDescriptor* mnudsc
							  )
{
  HideBorder();
  if (mnudsc)
		 Mnu = new UI_PopupMenu((UI_CompositeVObject*)_parent,mnudsc);
  else Mnu = NULL;
  Lbl = new SelectableLabel(this,
									 UI_Rectangle(0,_shape.Height()-lblhgt + 2,
									              _shape.Width(),lblhgt)
									 ,ID_ICON_LBL
									 );
  if (Lbl)
		Lbl->Title() = title;
  Bmp.BuildFrom(bmpname);
  TabStop(TRUE);
  return;
};


bool Icon :: MakeVisualElement()
{
  return UI_VObjCollection::MakeVisualElement();
};


void Icon :: Initialize       ()
{
  UI_VObjCollection::Initialize();
  return;
};


CL_String& Icon :: Title()
{
  return Lbl->Title();
};


// ****************
// Attributszugriff
// ****************


UI_Bitmap&     Icon :: bmp()
{
  return Bmp;
};


UI_Label*      Icon :: lbl()
{
  return Lbl;
};


UI_PopupMenu*& Icon :: mnu()
{
  return Mnu;
};


// **************************************************************************
// *                            EVENT-HANDLING                              *
// **************************************************************************



bool Icon :: Paint (const UI_Rectangle& r)
{
    bool res = UI_VObjCollection::Paint(r);
	 CreateDisplaySurface ();
	 _displaySurface->ColorRectangle( UI_Rectangle(0,0,_shape.Width(),
																		_shape.Height()
																 ),
												 _parent->Background()); // fill this area
	 UI_RectangleStruct shp = {
										 0,               // shp is the client area
										 0,               // the bitmap will be drawn
										 _shape.Width(),  // on.
										 _shape.Height() - Lbl->Shape().Height() - 2
									  };
	 UI_Point pt (
						(shp.w - Bmp.Width())  / 2,   // Bmp must be painted in the
						(shp.h - Bmp.Height()) / 2    // center of shp, so its top
					 );                              // left corner is pt.
	 Bmp.DrawOn (*_displaySurface,pt);
	 if (Lbl->isSelected())
       _displaySurface->InvertRectangle(shp);
	 DestroyDisplaySurface ();
	 return res;
};


bool Icon :: ButtonDown(const UI_Point& p, UI_MouseButton btn, bool, bool)
{
  Select();
  if (Mnu && btn == UIM_Right)
	  Mnu->ShowAt(p);
  return FALSE;
};


bool Icon :: KeyTyped(char k)
{
  if (Lbl && Lbl->isSelected())
	  if (k == KeySpace || k == KeyEnter)
		  sendEvent(Event_LButtonDblClk);
  return FALSE;
};


bool Icon :: Select()
{
  bool res = UI_VObjCollection::Select();
  if (Lbl && !Lbl->isSelected())
	{
	  Lbl->Select();
	  CreateDisplaySurface ();
	  UI_RectangleStruct shp = {
										 0,               // shp is the client area
										 0,               // the bitmap will be drawn
										 _shape.Width(),  // on.
										 _shape.Height() - Lbl->Shape().Height() - 2
										};
	  _displaySurface->InvertRectangle(shp);
	  DestroyDisplaySurface ();
	};
  return res;
};


bool Icon :: Unselect()
{
  if (Lbl && Lbl->isSelected())
  {
	  Lbl->Unselect();
	  CreateDisplaySurface ();
	  UI_RectangleStruct shp = {
										 0,               // shp is the client area
										 0,               // the bitmap will be drawn
										 _shape.Width(),  // on.
										 _shape.Height() - Lbl->Shape().Height() - 2
										};
	  _displaySurface->InvertRectangle(shp);
	  DestroyDisplaySurface ();
	};
  return FALSE;
};


void Icon :: ToggleSelection()
{
  if (Lbl)
	  Lbl->ToggleSelection();
  return;
};


bool Icon :: isSelected() const
{
  if (Lbl)
		 return Lbl->isSelected();
  else return FALSE;
};


void Icon :: sendEvent(UI_EventType t)

{

  UI_Event* e = new UI_Event(t,this);
  _Controller->AddEvent (e);
  return;
};

