
// ##########################################################################
// #                                                                        #
// #                              ExtNumberEditor                           #
// #                                                                        #
// #                            - Deklarationen -                           #
// #                                                                        #
// ##########################################################################


#ifndef _ExtNumberEditor_H
#define _ExtNumberEditor_H


#include"ui/stred.h"
#include"gui/strconv.h"



class ExtNumberEditor : public UI_StringEditor
{

  public:

	 ExtNumberEditor (UI_VObjCollection*  parent,
							const UI_Rectangle& shape,
							UI_ViewID           id,
							unsigned            range = 10,
							unsigned            pr    =  0,
							char                sep   = ',',
							bool                sgn   = FALSE
						  );


	 bool             initModel      (double x);

	 double           asDouble       ();

	 long int         asLong         ();

	 double           get_Minimum    () const;

	 void             set_Minimum    (double);

	 double           get_Maximum    () const;

	 void             set_Maximum    (double);

	 bool             hasMinimum     () const;

	 bool             hasMaximum     () const;

	 void             disableMaximum ();

	 void             disableMinimum ();


		 // check or correct the value:


	 bool             valueCorrection(double&) const;  // correct given value
	 bool             withinBounds   (double)  const;


	 void             limitLength    ();

	 void             sendEvent      ();

	 StringConverter& cnv            ();


	protected:

	 virtual         ~ExtNumberEditor();
	 virtual void    Initialize      ();
	 virtual void    _PrivateInitialize();
	 virtual bool    FilterChar      (short& key);
	 virtual bool    KeyTyped        (char);
	 bool            precisionOk     (CL_Integer&);
	 bool            signOk          (CL_Integer&);
	 bool            separatorOk     (CL_Integer&);
	 long int        commaPos        ();
	 double          Minimum;
	 double          Maximum;
	 bool            MaxDef;
	 bool            MinDef;
	 StringConverter Cnv;
};

#endif _ExtNumberEditor_H
