
// ##########################################################################
// #                                                                        #
// #                                  Chart                                 #
// #                                                                        #
// #                            - Deklarationen -                           #
// #                                                                        #
// ##########################################################################


#ifndef _Chart_H
#define _Chart_H


#include"ui/vobjcoll.h"
#include"ui/label.h"
#include"gui/clpair.h"
#include"gui/strconv.h"
#include"base/sequence.h"


#define ID_CHART       14000
#define ID_CHART_DSCX  14001
#define ID_CHART_DSCY  14002
#define ID_CHART_TITLE 14003


typedef CL_Sequence<CL_Pair> PairSequence;

enum ChartStyle {LINEAR,GRADUAL};



class Chart : public UI_VObjCollection
{

  typedef void (Chart::*ChartMethod)();

  public:

	 Chart (UI_VObjCollection*  parent,
			  const UI_Rectangle& shape,
			  UI_ViewID           id    = -1,
			  const char*         ttl   = "",
			  ChartStyle          style = LINEAR
			 );


	 void draw      ();  // do draw

	 bool drawXAxis ();

	 bool drawYAxis ();

	 bool labelXAxis();

	 bool labelYAxis();


	 long   coordX(double x) const; // x-coordinate of function's x-value

	 long   coordY(double y) const; // y-coordinate of function's y-value

	 double valueX(long   x) const; // function's x-value of coordinate x

	 double valueY(long   y) const; // function's y-value of coordinate y



	 PairSequence&    values  ();

	 UI_Rectangle&    area    ();

	 CL_String&       Title   ();

	 unsigned&        labelW  ();

	 unsigned&        labelH  ();

	 UI_Label*        dscX    ();

	 UI_Label*        dscY    ();

	 unsigned&        distance();

	 short unsigned&  drawOption();

	 UI_Color&        brushColor();
	 UI_Color&        penColor  ();

	 StringConverter& cnvX();

	 StringConverter& cnvY();

	 void             set_Style(ChartStyle);

	 ChartStyle       get_Style() const;


	 void  reshapeLabels();

	 bool  setExtrema();


	protected:

	 virtual         ~Chart();
	 bool             fillArray  ();// initiate filling of  point-array
	 void             polyLinear ();// fill point array with the points...
	 void             polyGradual();// ...necessary for a linear/gradual chart
	 bool             drawXLabel (long cx, double vx, unsigned half);// draw the
	 bool             drawYLabel (long cy, double vy, unsigned half);// label
	 virtual bool     MakeVisualElement();
	 virtual void     Initialize       ();
	 virtual bool     Paint(const UI_Rectangle&);
	 double           MaxX;         // Highest X-Value of function
	 double           MaxY;         // Highest Y-Value of function
	 double           MinX;         // Lowest  X-Value of function
	 double           MinY;         // Lowest  Y-Value of function
	 unsigned         LabelW;       // Textwidth of axis mark
	 unsigned         LabelH;       // Textwidth of axis mark
	 unsigned         Num;          // Number of points
	 UI_Rectangle     Area;         // Area of chart
	 PairSequence     Values;       // the values
	 UI_Point*        Points;       // the points
	 UI_Label*        DscX;         // label of x-axis
	 UI_Label*        DscY;         // label of y-axis
	 UI_Label*        CTitle;       // the title
	 unsigned         Distance;     // distance between two labels of an axis
	 short unsigned   DrawOption;   // filling and outline
	 UI_Color         BrushColor;   // filling colour
	 UI_Color         PenColor;     // line colour
	 StringConverter  CnvX;         // number conversion of x-axis
	 StringConverter  CnvY;         // number conversion of y-axis
	 ChartMethod      Poly;         // method called for drawing
	 ChartStyle       Style;        // style of chart
	 unsigned         Delta;        // number of indices between the point-index
											  // and the corresponding value index
};

#endif _Chart_H
