// File: main.c++

#include <ui/ApplicationWithAccel.h>
#include "ui/composit.h"

#include "MenuDriver.h"

//////////////////////////////////////////////////////////////////////////
// BEGIN Class MainWindow

// I derive the UI_CompositeVObject class to give it a MenuDriver.
class MainWindow : public UI_CompositeVObject
{
public :
   MainWindow(UI_CompositeVObject* parent, const UI_Rectangle& shape,
      UI_ViewID id = -1);
   ~MainWindow() { delete _driver; }

   protected:
      MenuDriver *_driver;
};

inline MainWindow::MainWindow(UI_CompositeVObject* parent,
   const UI_Rectangle& shape, UI_ViewID id) :

   UI_CompositeVObject(parent, shape, id)
{
   _driver = new MenuDriver(this);
}

// END Class MainWindow
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
// Main program

// Here is the one and only Application instance: we create an
// ApplicationWithAccel, not an Application
static UI_Application* _TheApplication = new UI_ApplicationWithAccel;

int UI_Application::Main (int, char* [])
{
    MainWindow* root = new MainWindow(NULL,
      UI_Rectangle (100, 100, 400, 200));
    root->Title() = "Accelerator sample application";
    MakeTopWindow (root);
    Run();
    return 0;
}

