
// File: ControllerWithAccel.h

#ifndef ControllerWithAccel_H
#define ControllerWithAccel_H

#include <ui/cntroler.h>
#include <ui/menu.h>
#include <base/map.h>
#include <base/integer.h>

// This structure is used to specify arrays containing the accelerator tables.
struct UI_AcceleratorTable
{
   long key;
   UI_ViewID targetID;
   UI_EventType eventType;
};


enum Key_Flag
{
   Key_Virtual = 0x00010000,
   Key_Shift   = 0x00020000,
   Key_Ctrl    = 0x00040000,
   Key_Alt     = 0x00080000
};

// Here I #define the portable equivalents of virtual keys: function keys,
// movement keys and edit keys
#ifdef __OS2__

#define VKey_F(n)            (VK_F1 + n - 1)
#define VKey_Cancel          VK_CANCEL
#define VKey_Backspace       VK_BACK
#define VKey_Tab             VK_TAB
#define VKey_Escape          VK_ESC

// Movement keys
#define VKey_PgUp       VK_PGUP
#define VKey_PgDown      VK_PGDN
#define VKey_Home       VK_HOME
#define VKey_End         VK_END
#define VKey_Up         VK_UP
#define VKey_Down       VK_DOWN
#define VKey_Left       VK_LEFT
#define VKey_Right      VK_RIGHT

// Edit keys
#define VKey_Insert      VK_INSERT
#define VKey_Delete      VK_DELETE

#endif /* __OS2__ */

class UI_ControllerWithAccel : public UI_Controller
{
public:
   // Construction and destruction
   UI_ControllerWithAccel(UI_Application* app) : UI_Controller(app) {}
   ~UI_ControllerWithAccel() { _accelTable.DestroyContents(); }

public:
   // Addition and removal of accelerators
   bool AddAccelerator(long, UI_VisualObject*, UI_EventType);
   bool RemoveAccelerator(long);

   bool AddAcceleratorTable(UI_AcceleratorTable*, UI_Menu&);
   void RemoveAllAccelerators() { _accelTable.DestroyContents(); }

private:
   virtual bool TranslateNativeEvent(NativeEventStruct& msg, UI_Event& e);

   // This class is for internal use only, so it is made private to
   // UI_ControllerWithAccel
   class UI_AcceleratorTarget : public CL_Object
   {
   public:
      UI_VisualObject* target;   // recipient of the event to be sent
      UI_EventType eventType;    // type of event to be sent to the
                                 // recipient
   };

protected:
   // The accelerator table
   CL_IntPtrMap _accelTable;
};

#endif

