// File: ApplicationWithAccel.h

/************************************************************************/
/*                                                                      */
/*                     Application with Accelerator Table               */
/*                                                                      */
/* This class is derived from UI_Application.  It overrides the Initia- */
/* lize() method to create a ControllerWithAccel rather than a Control- */
/* ler.                                                                 */
/*                                                                      */
/************************************************************************/

#ifndef ApplicationWithAccel_H
#define ApplicationWithAccel_H

#include <ui/applic.h>

class UI_ApplicationWithAccel : public UI_Application
{
public:
   // This is a cut-and-paste from <ui/applic.h>

   #if defined(__MS_WINDOWS__) || defined(__MS_WIN32__)
   virtual void Initialize (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdln,
      int nCmdShow);
       // [MS-Windows-specific method]
       // Initialize the application, and create and initialize the single
       // Controller instance.

   #elif defined(__X_MOTIF__)
   virtual void Initialize (int& argc, char *argv[]);
       // [X-Windows-specific method]
       // Initialize the application, and create and initialize the single
       // Controller instance.

   #elif defined(__OS2__)
       virtual void Initialize (int argc, char *argv[]);
       // [OS/2-specific method]
       // Initialize the application, and create and initialize the single
       // Controller instance.

   #endif
};

#endif
