


#
# -------------  Makefile for building YACL using Borland C++ -------------
#


!if !$d(YACLPATH)
!error Please define the environment variable YACLPATH.
!endif



!include $(YACLPATH)\control\borlandc.ctl



FLAGS = -D$(YACLPLATFORM)

!if $d(DEBUG)
FLAGS = $(FLAGS) -DDEBUG
!endif

!if $d(BUILD_DLL)
FLAGS = $(FLAGS) -DBUILD_DLL
!endif

yacl:  libdir base io ui

libdir:
	-md $(YACLPATH)\lib
	-md $(YACLPATH)\lib\$(YACLPLATFORM)

base:
	cd base
	-$(MAKE) -fborlandc.mak $(FLAGS)
	-cd ..

io:
        cd io
	-$(MAKE) -fborlandc.mak $(FLAGS)
        -cd ..


ui:
!if $(YACLPLATFORM) == WINDOWS || $(YACLPLATFORM) == OS2 || $(YACLPLATFORM) == WIN32
	cd ui
	-$(MAKE) -fborlandc.mak $(FLAGS)
        -cd ..
!else
	@echo  UI not made: not supported for $(YACLPLATFORM)
!endif




yacldlls: libdir base_dll io_dll  ui_dll

base_dll:
	cd base
	-$(MAKE) -fborlandc.mak -DBUILD_DLL $(FLAGS)
	-cd ..

io_dll:
        cd io
	-$(MAKE) -fborlandc.mak -DBUILD_DLL $(FLAGS)
        -cd ..


ui_dll:
	cd ui
	-$(MAKE) -fborlandc.mak -DBUILD_DLL  $(FLAGS)
        -cd ..




# -------------------- Targets below are for my use only ---------------

    
basedemo:
    cd basedemo
    $(MAKE) -f borlandc.mak
    cd ..

uidemos:
    cd uidemo
    $(MAKE) -f borlandc.mak
    cd ..


apps:
    cd apps\bmpview
    $(MAKE) -f borlandc.mak
    cd ..\dlged
    $(MAKE) -f borlandc.mak
    cd ..\..
    
    
everything: yacl uidemos apps




dist:
  -rm -f yacl.zip
  -copy $(BCPATH)\include\ctl3d.h lib\windows
  ls base/*.h base/*.cxx base/*.mak io/*.h io/*.cxx \
  io/*.mak ui/*.h ui/*.cxx ui/*.mak > $(TMP)\z1.tmp
  find ui/support -type f -print >> $(TMP)\z1.tmp
  find apps contrib basedemo uidemo -type f -print > $(TMP)\z2.tmp
  egrep -iv "\.(tr2|td2|ilk|pdb|dbg|lnk|ini|tr2|trw|tdw|td|log|lib|zip|bak|obj|exe|map|res|rws|vcp)$" $(TMP)\z2.tmp >>  $(TMP)\z1.tmp
  find control tools -print >> $(TMP)\z1.tmp
  ls *.txt *.mak doc/* >> $(TMP)\z1.tmp
  ls lib/win*/ctl3d*.[hd]* >> $(TMP)\z1.tmp
  egrep -v "misc|zzsave" $(TMP)\z1.tmp > $(TMP)\z2.tmp
  sort -u < $(TMP)\z2.tmp > $(TMP)\z1.tmp
  $(ZIP) yacl.zip -@ < $(TMP)\z1.tmp
    
    
  
zip:
  rm -f yacl_all.zip
  find . -type f -print > $(TMP)\z1.tmp
  egrep -v "\.(dll|tdw|trw|td2|tr2|ilk|lk|pdb|toc|idx|lib|zip|obj|exe|res|log|bak|map|vcp|o)$"< $(TMP)\z1.tmp > $(TMP)\z2.tmp
  find . -name "ctl3d*" -print >> $(TMP)\z2.tmp
  sort -u < $(TMP)\z2.tmp >  $(TMP)\z1.tmp
  $(ZIP) yacl_all.zip -@ < $(TMP)\z1.tmp
  rm -f $(TMP)/z1.tmp $(TMP)/z2.tmp



srczip:
    -rm -f yaclsrc.zip
    -copy $(BCPATH)\include\ctl3d.h lib\windows
    ls base/*.h base/*.cxx base/*.mak io/*.h io/*.cxx io/*.mak \
    ui/*.h ui/*.cxx ui/*.mak > $(TMP)\makxxx.tmp
    find basedemo uidemo uidevlop -type f -print > $(TMP)\z2.tmp
    egrep "makefile|cxx$|h$|rc$|def$|txt$" $(TMP)\z2.tmp >>  $(TMP)\makxxx.tmp
    find tools -print >> $(TMP)\makxxx.tmp
    echo "shipping.lst" >> $(TMP)\makxxx.tmp
    echo "lib/windows/ctl3d.dll"  >> $(TMP)\makxxx.tmp
    echo "lib/windows/ctl3d.h"  >> $(TMP)\makxxx.tmp
    echo "changlog"  >> $(TMP)\makxxx.tmp
    ls *.txt *.ctl *.mak >> $(TMP)\makxxx.tmp
    egrep -v "misc|zzsave" < $(TMP)\makxxx.tmp > $(TMP)\z2.tmp
    sort $(TMP)\z2.tmp > $(TMP)\makxxx.tmp
    $(ZIP) yaclsrc.zip -@ < $(TMP)\makxxx.tmp
    
    
basezip:
    -del yaclbase.zip
    ls base/*.h base/*.cxx base/*.mak > $(TMP)\z1.tmp
    sort $(TMP)\z1.tmp > $(TMP)\z2.tmp
    $(ZIP) yaclbase -@ < $(TMP)\z2.tmp
   

clean:
    cd base
    -$(MAKE) -fborlandc.mak -D$(YACLPLATFORM) clean
    cd ..\io
    -$(MAKE) -fborlandc.mak -D$(YACLPLATFORM) clean
    cd ..\ui
    -$(MAKE) -fborlandc.mak -D$(YACLPLATFORM) clean
    cd ..
    cd basedemo
    -rm -f */*.obj */*.exe */*.map
    cd ..\uidemo
    $(MAKE) -f borlandc.mak -D$(YACLPLATFORM) clean
    cd $(YACLLIB)
	-del base.*
	-del io.*
	-del ui.*
	-del memory.*
	-del *.bak
    cd ..\..
    cd apps\dlged
    $(MAKE) -f borlandc.mak -D$(YACLPLATFORM) clean
    cd ..\bmpview
    $(MAKE) -f borlandc.mak -D$(YACLPLATFORM) clean
    cd ..\..


