

// A second version of the reminder program: prints out the data in
// chronological order.
//
// M. A. Sridhar
// Feb 13, 1994

#include "base/string.h"
#include "base/objseq.h"
#include "base/date.h"

#include <iostream.h>


class ReminderEntry: public CL_Object {

public:
    ReminderEntry (const CL_Date& dt, const CL_String& msg)
        : _date (dt), _msg (msg) {};
    ~ReminderEntry () {}; // Needed because Object's destructor is pure virt.
    
    const CL_Date&   Date () const {return _date;};
    const CL_String& Message () const {return _msg;};
    
    short Compare (const CL_Object&) const;
    // Override inherited Compare, so that sorting is possible

protected:
    // Data elements:
    CL_Date _date;
    CL_String _msg;
};


short ReminderEntry::Compare (const CL_Object& o) const
{
    const ReminderEntry& entry = (const ReminderEntry&) o; // Cast down
    short r = _date.Compare (entry._date);
    return r ? r : _msg.Compare (entry._msg);
}



// -------------------------- Main program --------------------------    

void main ()
{
    CL_Date today = CL_Date::Today();
    CL_String s;
    CL_ObjectSequence result;
    while (s.ReadLine (cin)) {
        if (s.Size() <= 0) continue; // Allow for blank lines
        CL_String fld[2];
        s.Split (fld, 2);
        short month = fld[0].Field (1, "/").AsLong();
        short day   = fld[0].Field (2, "/").AsLong();
        CL_Date date (today.Year(), month, day);
        if (date.IsLegal() && date.IsBetween (today, today+4))
            result.Add (new ReminderEntry (date, fld[1]));
    }

    result.Sort ();
    for (short i = 0; i < result.Size(); i++) {
        ReminderEntry* p = (ReminderEntry*) result[i];
        cout << p->Date() << ":" << p->Message() << endl;
    }
    result.DestroyContents(); // Prevent memory leaks
}

