


#include "base/regexpr.h"
#include <iostream.h>
#include <stdlib.h>

#include "base/memory.h"

CL_MemoryLeakChecker ck (cout);
void main (int argc, char* argv[])
{
    if (argc != 3) {
        cerr << "Usage: " << argv[0] << " regexp string\n";
        exit (1);
    }

    CL_RegExpr exp (argv[1]);
    CL_String err = exp.LastError ();
    if (err.Size() > 0) {
        cerr << "RegExp construction failed: " << err.AsPtr() << endl;
        exit (1);
    }

    CL_RegExpr::IntPair pair [CL_RegExpr::MAX_PAIRS];
    long nMatches = exp.Match (argv[2], pair);
    err = exp.LastError ();
    if (err.Size() > 0) {
        cerr << "RegExp match failed: " << err.AsPtr() << endl;
        exit (1);
    }
    if (nMatches < 0) 
        cout << "No match.\n";
    else {
        short i;
        cout << " Matches found:\n";
        for (i = 0; i < nMatches; i++) {
            cout << "   position " << pair[i].position <<
                    " length " << pair[i].length << endl;
        }
    }
}
