



#ifndef _company_h_ /* Fri Aug 18 12:38:27 1995 */
#define _company_h_

#include "base/object.h"
#include "base/tbtree.h"

class Company: public CL_Object {

public:
    Company () {};   // Needed if Company must be a template parameter

    ~Company () {};  // Needed because Object's destructor is pure virtual
    
    Company (const char* name, const char* address, const char* phone);

    Company (const Company& p) {*this = p;};
    
    void operator= (const CL_Object& p) {*this = (const Company&) p;};

    Company& operator= (const Company& p);
    
    short Compare (const Company& p) const;
    
    short Compare (const CL_Object& p) const
        {return Compare ((const Company&) p);};

    CL_String AsString () const;
    
protected:
    CL_String _name;
    CL_String _address;
    CL_String _phone;
};


#endif /* _company_h_ */
