


#if defined(__GNUC__)
#pragma implementation
#endif

#include "company.h"
#include "base/iterator.h"
#include "base/cmparatr.cxx"

#if defined(__GNUC__)
// Force the instantiation of the class templates:
template class CL_Comparator<Company>;
template class CL_Basics<Company>;
template class CL_Iterator<Company>;
#elif defined(_MSC_VER)
template CL_Comparator<Company>;
template CL_Basics<Company>;
template CL_Iterator<Company>;
#endif

#if defined(__BORLANDC__) || defined(__WATCOMC__)
// Force the instantiation of the class templates:
typedef CL_Comparator<Company> CompanyComparator;
typedef CL_Iterator<Company> IteratorCompany;
typedef CL_Basics<Company> BasicsCompany;
#endif

// Initialize the static _Null:
// Company CL_Basics<Company>::_Null = CL_Basics<Company>::NullValue();


Company::Company  (const char* name, const char* address, const char* phone)
: _name (name), _address (address), _phone (phone)
{
}

short Company::Compare (const Company& p) const
{
    // Use only company name to determine alphabetical order
    return _name.Compare (p._name);
}


Company& Company::operator= (const Company& p)
{
    if (PrepareToChange()) {
        _name    = p._name;
        _address = p._address;
        _phone   = p._phone;
        Notify();
    }
    return *this;
}


CL_String Company::AsString () const
{
    return _name + ", " + _address + ", " + _phone;
}
