



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#if defined(__GNUC__)
#pragma implementation
#endif


#include "base/setimp.cxx"
#include "base/basicops.cxx"

#if defined(__GNUC__)
template class CL_Set<CL_String>;
template class CL_Iterator<CL_String>;
template class CL_SetIterator<CL_String>;
template class CL_Binding0<CL_SetIterator<CL_String> >;
template class SetImplSeq<CL_String>;
// template class CL_Basics<CL_String>;
#elif defined(_MSC_VER)
// The following pragma is needed to disable a warning about CL_Iterator
// methods not neing available:
#pragma warning (disable:4661)

template CL_Set<CL_String>;
template CL_Iterator<CL_String>;
template CL_SetIterator<CL_String>;
template CL_Binding0<CL_SetIterator<CL_String> >;
template SetImplSeq<CL_String>;
#endif



#if defined(__IBMCPP__)
#include "base/cmparatr.cxx"

#pragma define(CL_Set<CL_String>)
#pragma define(CL_SetIterator<CL_String>)
#pragma define(CL_Basics<CL_String>)
#pragma define(CL_Comparator<CL_String>)
#elif defined(__SGI_DELTA_CC__)
#include "base/cmparatr.cxx"
#pragma instantiate CL_Set<CL_String>
#pragma instantiate CL_SetIterator<CL_String>
#pragma instantiate CL_Basics<CL_String>
#pragma instantiate CL_Comparator<CL_String>
#endif


typedef CL_Sequence<CL_String> StringSequence;

#include "base/strgset.h"


CL_StringSet::CL_StringSet (const char* data[])
{
    for (long i = 0; data[i] != NULL; i++)
        Add (data[i]);
}


CL_StringSet CL_StringSet::StringsWithPrefix (const CL_String& s) const
{
    CL_StringSet ret;
    if (!_idata)
        return ret;
    StringSequence& _data = (* (StringSequence*) _idata);
    long pos = 0;
    bool b = _data.BinarySearch (s, pos);
    register long n = _data.Size();
    for (register long i = b ? pos : pos+1; i < n; i++) {
        if (!s.IsPrefixOf (_data[i]))
            break;
        ret.Add (_data[i]);
    }
    return ret;
}




CL_Set<CL_String>& CL_StringSet::operator= (const CL_Set<CL_String>& o)
{
    CL_Set<CL_String>::operator= (o);
    return *this;
}


void CL_StringSet::operator= (const CL_Object& o)
{
    if (o.IsA (*this))
        CL_Set<CL_String>::operator= (o);
}
