

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#include <limits.h>

#include "vobjdesc.h"
#include "vobjset.h"
#include "vobjdptr.h"

#include "base/setimp.cxx"

#if defined(__GNUC__)

template class CL_Set<VObjDesc*>;
template class SetImplSeq<VObjDesc*>;
template class CL_SetIterator<VObjDesc*>;

#elif defined(_MSC_VER)

template CL_Set<VObjDesc*>;
template SetImplSeq<VObjDesc*>;
template class CL_SetIterator<VObjDesc*>;

#elif defined(__SGI_DELTA_CC__)

#pragma instantiate CL_Set<VObjDesc*>
// #pragma instantiate SetImplSeq<VObjDesc*>

#endif


VObjSet::VObjSet ()
{
}


VObjSet::~VObjSet ()
{
}


VObjDesc* VObjSet::PointHits (const UI_Point& p) const
{
    // We return the VObj of smallest area that is hit by the point
    long area = LONG_MAX;
    VObjDesc* w = (VObjDesc*) NULL;
    VObjSetIterator itr (*this);
    while (itr.More()) {
        VObjDesc* v = itr.Next();
        if (v->IsHitBy (p) && v->_shape.Area() < area) {
            w = v;
            area = w->_shape.Area();
        }
    }
    return w;
}


void VObjSet::DestroyContents ()
{
    // First, we'll destroy all pointed-to VObjDesc objects:
    VObjSetIterator itr (*this);
    while (itr.More()) {
        VObjDesc* v = itr.Next();
        delete v;
    }

    // Now empty the set itself, i.e., set its size to zero:
    MakeEmpty();
}


void VObjSet::operator= (const CL_Object& o)
{
    *this = (const VObjSet&) o;
}


CL_Set<VObjDesc*>& VObjSet::operator= (const CL_Set<VObjDesc*>& o)
{
    CL_Set<VObjDesc*> :: operator= (o);
    return *this;
}


