

#ifndef _vobjdptr_h_ /* Wed Dec 20 18:13:55 1995 */
#define _vobjdptr_h_


// Overrides of template functions for basic operations for VObjDescPtr
#include "base/basicops.h"

typedef VObjDesc* VObjDescPtr;

inline VObjDescPtr       CL_Basics<VObjDescPtr>::NullValue ()
{
    return 0;
}


// inline VObjDescPtr&      CL_Basics<VObjDescPtr>::NullValueRef ()
// {
//     _Null = (VObjDescPtr) 0;
//     return _Null;
// }


inline short CL_Basics<VObjDescPtr>::Compare
    (const VObjDescPtr& o1, const VObjDescPtr& o2)
{
#if defined(__MS_WINDOWS__)
    void huge* p1 = o1, *p2 = o2;
    return (o1 == NULL || o2 == NULL || !o2->IsA (*o1))
        ? (p1 < p2 ? -1 : (p1 == p2 ? 0 : 1))
        : (o1->Compare (*o2));
#else
    long l1 = (const long&) o1, l2 = (const long&) o2;
    return (o1 == NULL || o2 == NULL || !o2->IsA (*o1)) ?
        (l1 < l2 ? -1 : (l1 == l2 ? 0 : 1))
        : (o1->Compare (*o2));
#endif
}



inline CL_String  CL_Basics<VObjDescPtr>::PrintableForm
    (const VObjDescPtr& o)
{
    
    CL_String s;
    if (!o)
        s = "0x0";
    else
        s = o->AsString ();
    return s;
}


inline bool       CL_Basics<VObjDescPtr>::Read (VObjDescPtr& p,
                                                const CL_Stream& s)
{
    return s.Read ((CL_ObjectPtr&) p);
}


inline bool       CL_Basics<VObjDescPtr>::Write (const VObjDescPtr& p,
                                                 CL_Stream& s)
{
    return s.Write (p);
}


inline long       CL_Basics<VObjDescPtr>::StoreWidth (const VObjDescPtr& p)
{
    return p ? p->StorableFormWidth ()  : 0;
}


inline VObjDescPtr&      CL_Basics<VObjDescPtr>::Deref (const CL_VoidPtr& p)
{
    return (VObjDescPtr&) p;
}

inline void       CL_Basics<VObjDescPtr>::Destroy (CL_VoidPtr)
{
    // Do nothing
}


inline CL_VoidPtr    CL_Basics<VObjDescPtr>::MakeCopy (const VObjDescPtr& o)
{
    register CL_VoidPtr p = (const CL_VoidPtr&) o;
    return p;
}

inline CL_VoidPtr    CL_Basics<VObjDescPtr>::MakePointer
    (const VObjDescPtr& o)
{
    register CL_VoidPtr p = (const CL_VoidPtr&) o;
    return p;
}

inline void          CL_Basics<VObjDescPtr>::DoDestroy (const VObjDescPtr& p)
{
    if (p)
        delete p;
}




#endif /* _vobjdptr_h_ */
