

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "vobjdesc.h"
#include "util.h"

#include "base/basicops.h"
#include "base/iterator.h"
#include "base/cmparatr.h"

// We now have to worry about generating the basic operations for VObjDesc*
// (i.e. pointers to VObjDesc), since we want to use sets of VObjDesc
// pointers:

#if defined(__CFRONT__)
#define inline
#endif

typedef VObjDesc* VObjPtr;

// inline VObjPtr& CL_Basics<VObjPtr>::NullValueRef ()
// {
//     _Null = 0;
//     return _Null;
// }

inline VObjPtr       CL_Basics<VObjPtr>::NullValue ()
{
    return 0;
}

inline short CL_Basics<VObjPtr>::Compare (const VObjPtr& o1,
                                          const VObjPtr& o2)
{
    return (o1 < o2) ? -1 : ((o1 == o2) ? 0 : 1);
}
    


inline CL_String      CL_Basics<VObjPtr>::PrintableForm (const VObjPtr& o) 
{
    CL_String s;
    s.AssignWithFormat ("%lx", o);
    return s;
}

inline bool           CL_Basics<VObjPtr>::Read (VObjPtr& ,
                                                  const CL_Stream&) 
{
    return FALSE;
}

inline bool           CL_Basics<VObjPtr>::Write (const VObjPtr&,
                                                  CL_Stream&) 
{
    return FALSE;
}

inline long           CL_Basics<VObjPtr>::StoreWidth (const VObjPtr& o) 
{
    return sizeof o;
}

inline void       CL_Basics<VObjPtr>::Destroy (CL_VoidPtr p)
{
}



inline CL_VoidPtr    CL_Basics<VObjPtr>::MakeCopy (const VObjPtr& o) 
{
    return  (CL_VoidPtr) o;
}


inline CL_VoidPtr    CL_Basics<VObjPtr>::MakePointer (const VObjPtr& o) 
{
    return  (CL_VoidPtr) o;
}


inline VObjPtr&      CL_Basics<VObjPtr>::Deref (const CL_VoidPtr& p)
{
    return (VObjPtr&) p;
}


inline void       CL_Basics<VObjPtr>::DoDestroy (const VObjPtr&)
{
}

short CL_Comparator<VObjPtr>::operator() (CL_VoidPtr p1, CL_VoidPtr p2)
    const
{
    if (p1 && p2) {
        VObjPtr q1 = (VObjPtr) p1;
        VObjPtr q2 = (VObjPtr) p2;
        return q1->Compare (*q2);
    }
    return p1 < p2 ? -1 : (p1 == p2 ? 0 : 1);
}


#if defined(__CFRONT__)
#undef inline
#endif




#if defined(__GNUC__)
// Force the instantiation of the class templates:
template class CL_Basics<VObjPtr>;
template class CL_Comparator<VObjPtr>;
template class CL_Iterator<VObjPtr>;
#elif defined(_MSC_VER)
template CL_Comparator<VObjPtr>;
template CL_Iterator<VObjPtr>;
#endif

// VObjPtr CL_Basics<VObjPtr>::_Null = 0;

enum {
    HIT_AREA_TOLERANCE = 2  // Number of pixels of leeway to allow from the
                            // mouse position to the point it is supposedly
                            // hitting
};

VObjDesc::VObjDesc (UI_ViewType type, UI_ViewID id, const UI_Rectangle&
                    rect)
{
    _type = type;
    _id   = id;
    _shape = rect;
    _isTabStop = type == View_Label ? FALSE : TRUE;
}


VObjDesc::VObjDesc (const VObjDesc& v)
{
    _id        = v._id;
    _type      = v._type;
    _shape     = v._shape;
    _title     = v._title;
    _isTabStop = v._isTabStop;
    _symbolicName  = v._symbolicName;
}


short VObjDesc::Compare (const VObjDesc& v) const
{
    if (_id != v._id)
        return _id < v._id ? -1 : 1;
    if (_type != v._type)
        return _type < v._type ? -1 : 1;
    if (_shape.Left() != v._shape.Left())
        return _shape.Left() < v._shape.Left() ? -1 : 1;
    if (_shape.Top() != v._shape.Top())
        return _shape.Top() < v._shape.Top() ? -1 : 1;
    return 0;
}


short VObjDesc::Compare (const CL_Object& obj) const
{
    return Compare (CL_CAST_REF (VObjDesc&, obj));
}


CL_String VObjDesc::AsString () const
{
    CL_String s;
    CL_String idStrg (_id);
    if (_symbolicName.Size())
        idStrg = _symbolicName;
    s.AssignWithFormat
        ("View_%-15s, %-12s, %4ld, %4ld, %4ld, %4ld, %s, \"%s\"",
         StringForm (_type).AsPtr(), idStrg.AsPtr(),
         _shape.Left(), _shape.Top(), _shape.Width(), _shape.Height(),
         _isTabStop ? "TRUE" : "FALSE", _title.AsPtr());
    return s;
}



VObjDesc::HitDirection VObjDesc::Direction (const UI_Point& pt) const
{
    UI_Rectangle hitArea (pt - UI_Vector (HIT_AREA_TOLERANCE,
                                          HIT_AREA_TOLERANCE),
                          2 * HIT_AREA_TOLERANCE, 2 * HIT_AREA_TOLERANCE);
    if (hitArea.Includes (_shape.TopLeft ()))
        return Dir_NW;
    if (hitArea.Includes (_shape.TopRight ()))
        return Dir_NE;
    if (hitArea.Includes (_shape.BottomLeft ()))
        return Dir_SW;
    if (hitArea.Includes (_shape.BottomRight ()))
        return Dir_SE;
    long l = _shape.Left(), t = _shape.Top (), r = _shape.Right(),
        b = _shape.Bottom();
    if (hitArea.Left() <= l && l <= hitArea.Right() &&
        hitArea.Top() >= t && hitArea.Bottom() <= b)
        return Dir_W;
    if (hitArea.Top()  <= b && b <= hitArea.Bottom() &&
        hitArea.Left() >= l && hitArea.Right() <= r)
        return Dir_S;
    if (hitArea.Top()  <= t && t <= hitArea.Bottom() &&
        hitArea.Left() >= l && hitArea.Right() <= r)
        return Dir_N;
    if (hitArea.Left() <= r && r <= hitArea.Right() &&
        hitArea.Top() >= t && hitArea.Bottom() <= b)
        return Dir_E;
    return Dir_None;
}

