

/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#include "menudrv.h"
#include "ids.h"
#include "appwin.h"

#include "ui/menu.h"
#include "ui/applic.h"
#include "ui/stddlg.h"
#include "ui/composit.h"


#if defined(__GNUC__)
template class UI_EventBinding2 <MenuDriver>; // Instantiate the binding
#endif

typedef UI_EventBinding2 <MenuDriver> MenuBinding;

struct DispatcherStruct {
    UI_ViewID              menu_id;
    MenuBinding::MethodPtr method;
    UI_EventType           event;
} FAR dispatch [] = {
    {ID_NEW,      MenuDriver::CatchAll,   Event_Select}
  , {ID_OPEN,     MenuDriver::CatchAll,   Event_Select}
  , {ID_SAVEAS,   MenuDriver::CatchAll,   Event_Select}
  , {ID_FONT,     MenuDriver::CatchAll,   Event_Select}
  , {ID_TESTDLG,  MenuDriver::CatchAll,   Event_Select}
  , {ID_QUIT,     MenuDriver::Quit,       Event_Select}

  , {ID_CUT,      MenuDriver::CatchAll,   Event_Select}
  , {ID_COPY,     MenuDriver::CatchAll,   Event_Select}
  , {ID_PASTE,    MenuDriver::CatchAll,   Event_Select}
  , {ID_DELETE,   MenuDriver::CatchAll,   Event_Select}
  , {ID_REPL,     MenuDriver::CatchAll,   Event_Select}
  , {ID_ALIGN,    MenuDriver::CatchAll,   Event_Select}
  , {ID_SIZE,     MenuDriver::CatchAll,   Event_Select}
  , {ID_PROP,     MenuDriver::CatchAll,   Event_Select}


  , {ID_LABEL,    MenuDriver::Choose,     Event_Select}
  , {ID_PUSHBN,   MenuDriver::Choose,     Event_Select}
  , {ID_STRVW,    MenuDriver::Choose,     Event_Select}
  , {ID_STRED,    MenuDriver::Choose,     Event_Select}
  , {ID_TGLBN,    MenuDriver::Choose,     Event_Select}
  , {ID_COMBO,    MenuDriver::Choose,     Event_Select}
  , {ID_HSCRL,    MenuDriver::Choose,     Event_Select}
  , {ID_VSCRL,    MenuDriver::Choose,     Event_Select}
  , {ID_TEXT,     MenuDriver::Choose,     Event_Select}
  , {ID_ORGRP,    MenuDriver::Choose,     Event_Select}
  , {ID_XRGRP,    MenuDriver::Choose,     Event_Select}
  , {ID_XRTGL,    MenuDriver::Choose,     Event_Select}
    
  , {ID_ABOUT,    MenuDriver::About,     Event_Select}

};



void MenuDriver::Setup (UI_Menu* menu)
{
    _menu = menu;
    for (short i = 0; i < sizeof dispatch/sizeof (DispatcherStruct); i++) {
        UI_ViewID id = dispatch[i].menu_id;
        (*menu)[id]->AddEventDependent
            (dispatch[i].event, MenuBinding (this, dispatch[i].method, id));
    }

    (*menu)[ID_LABEL]->SetCheck (UI_MenuItem::NotChecked); 
    (*menu)[ID_PUSHBN]->SetCheck (UI_MenuItem::NotChecked);
    (*menu)[ID_STRVW]->SetCheck (UI_MenuItem::NotChecked); 
    (*menu)[ID_STRED]->SetCheck (UI_MenuItem::NotChecked); 
    (*menu)[ID_TGLBN]->SetCheck (UI_MenuItem::NotChecked); 
    (*menu)[ID_COMBO]->SetCheck (UI_MenuItem::NotChecked); 
    (*menu)[ID_HSCRL]->SetCheck (UI_MenuItem::NotChecked); 
    (*menu)[ID_VSCRL]->SetCheck (UI_MenuItem::NotChecked); 
    (*menu)[ID_TEXT]->SetCheck (UI_MenuItem::NotChecked);  
    (*menu)[ID_ORGRP]->SetCheck (UI_MenuItem::NotChecked); 
    (*menu)[ID_XRGRP]->SetCheck (UI_MenuItem::NotChecked); 
    (*menu)[ID_XRTGL]->SetCheck (UI_MenuItem::NotChecked);     

    (*menu)[ID_EDIT]   ->Disable();
    (*menu)[ID_CREATE] ->Disable();
    (*menu)[ID_TESTDLG]->Disable();
    _checkedObjectID = 0;
}


UI_ViewType MenuDriver::CurrentObjectType () const
{
    switch (_checkedObjectID) {
    case    ID_LABEL:
        return View_Label;
        
    case    ID_PUSHBN:
        return View_PushButton;
        
    case    ID_STRVW:
        return View_StringViewSingle;
        
    case    ID_STRED:
        return View_StringEditor;
        
    case    ID_TGLBN:
        return View_ToggleButton;
        
    case    ID_XRTGL:
        return View_ExOrToggleButton;
        
    case    ID_COMBO:
        return View_ComboBox;
        
    case    ID_VSCRL:
        return View_VScrollBar;
        
    case    ID_HSCRL:
        return View_HScrollBar;
        
    case    ID_TEXT:
        return View_TextView;
        
    case    ID_ORGRP:
        return View_OrButtonGroup;
        
    case    ID_XRGRP:
        return View_ExOrButtonGroup;
        
    }
    return View_None;
}


bool MenuDriver::CatchAll (UI_Event&, long id)
{
    AppWindow* w = (AppWindow*) YACLApp()->MainWindow();
    DialogEditor& editor = w->Editor ();
    switch (id) {
    case ID_NEW:
        editor.DoNew ();
        if (editor.CurrentDialogName().Size() > 0) {
            (*_menu)[ID_EDIT]   ->Enable();
            (*_menu)[ID_CREATE] ->Enable();
            (*_menu)[ID_TESTDLG]->Enable();
        }
        break;
        
    case ID_OPEN:
        editor.DoOpen();
        if (editor.CurrentDialogName().Size() > 0) {
            (*_menu)[ID_EDIT]   ->Enable();
            (*_menu)[ID_CREATE] ->Enable();
            (*_menu)[ID_TESTDLG]->Enable();
        }
        break;

    case ID_SAVEAS:
        editor.DoSave();
        break;

    case ID_FONT:
        editor.DoFontChoice();
        break;

    case ID_REPL:
        editor.DoReplicate ();
        break;
        
    case ID_DELETE:
        editor.DoDelete ();
        break;
        
    case ID_ALIGN:
        editor.DoAlign  ();
        break;
        
    case ID_SIZE:
        editor.DoSize ();
        break;

    case ID_TESTDLG:
        editor.DoTest ();
        break;

    case ID_PROP:
        editor.DoProperties ();
        break;

    case ID_PASTE:
        if (editor.ClipboardSize() > 0)
            w->SetMode (AppWindow::PasteMode);
        else
            UI_StandardDialog ("Cannot paste from an empty clipboard",
                               "Dialog editor", w, UIS_Ok, UIS_Error);
        break;

    case ID_CUT:
        editor.DoCut ();
        break;

    case ID_COPY:
        editor.DoCopy ();
        break;
    }
    return FALSE;
}




    
bool MenuDriver::Choose (UI_Event&, long id)
{
    if (_checkedObjectID)
        (*_menu)[_checkedObjectID]->SetCheck (UI_MenuItem::NotChecked);
    (*_menu)[id]->SetCheck (UI_MenuItem::Checked);
    _checkedObjectID = id;
    AppWindow* w = (AppWindow*) YACLApp()->MainWindow();
    w->SetMode (AppWindow::CreateMode);
    return FALSE;
}




bool MenuDriver::Quit (UI_Event&, long)
{
    YACLApp()->End();
    return FALSE;
}


bool MenuDriver::About (UI_Event&, long)
{
    AppWindow* w = (AppWindow*) YACLApp()->MainWindow();
    DialogEditor& editor = w->Editor ();
    editor.DoAbout();
    return TRUE;
}

