

#ifndef _draghndl_h_ /* Sat Nov 25 13:32:40 1995 */
#define _draghndl_h_



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

// The DragHandler is an object that handles the user interface aspects of
// drawing a picture.  The DragHandler is created with two
// parameters: A VisualObject on which to draw the picture and a binding
// to execute when the  drawing operation is complete.
//
// A DragHandler is either in active state or non-active state.  It
// responds to and processes mouse events only if it is active. When active,
// the DragHandler assumes that the client VisualObject has a
// DisplaySurface already created for it. This DisplaySurface is used for
// handling the user feedback provided by the DragHandler.


#include "ui/visualob.h"
#include "vobjdesc.h"

class AppWindow;
class DragHandler: public CL_Object {

public:
    DragHandler (AppWindow* v,
                 const CL_AbstractBinding& finishBind);
    // Create a DragHandler. It will draw its rectangles on the given
    // VisualObject.

    ~DragHandler ();

    void SetActiveState (bool state);


protected:

    bool _MouseDownEvt (UI_Event& e);

    bool _MouseMoveEvt (UI_Event& e);

    bool _MouseUpEvt   (UI_Event& e);

    virtual bool _MouseDown (UI_DisplaySurface& sfc, const UI_Point& p) = 0;
                            
    virtual bool _MouseMove (UI_DisplaySurface& sfc, const UI_Point& p) = 0;
                            
    virtual bool _MouseUp   (UI_DisplaySurface& sfc, const UI_Point& p) = 0;

    AppWindow*          _client;
    CL_AbstractBinding* _finishBind;
    bool                _active;
    UI_Point            _downEventPoint; // Where the mouse-down event
                                         // occurred
    bool                _modeChanged;
};


// A RectanglePainter is a DragHandler that draws a rubber-band rectangle.
// The drawing is completed when the user finishes the drag and releases
// the mouse.

class  RectanglePainter: public    DragHandler {

public:
    RectanglePainter (AppWindow* v, 
                      const CL_AbstractBinding& finishBind);
    // Create a DragHandler. It will draw its rectangles on the given
    // VisualObject.

    const UI_Rectangle& Rectangle () const {return _rect;};
    // Return the currently-drawn rectangle.

protected:

    bool _MouseDown (UI_DisplaySurface& sfc, const UI_Point& p);
    
    bool _MouseMove (UI_DisplaySurface& sfc, const UI_Point& p);
    
    bool _MouseUp   (UI_DisplaySurface& sfc, const UI_Point& p);

    UI_Rectangle        _rect;
};

class  MoveHandler: public    DragHandler {

public:
    MoveHandler (AppWindow* v, 
                 const CL_AbstractBinding& finishBind);
    // Create a DragHandler. It will draw its rectangles on the given
    // VisualObject.

    const UI_Vector& Translation () const {return _vector;};
    // Return the currently-drawn rectangle.

protected:

    bool _MouseDown (UI_DisplaySurface& sfc, const UI_Point& p);
    
    bool _MouseMove (UI_DisplaySurface& sfc, const UI_Point& p);
    
    bool _MouseUp   (UI_DisplaySurface& sfc, const UI_Point& p);

private:
    void _DrawRectangles (UI_DisplaySurface& sfc, const UI_Vector&);
    
    UI_Vector           _vector;
};







class  SizeHandler: public    DragHandler {

public:
    SizeHandler (AppWindow* v, 
                 const CL_AbstractBinding& finishBind);
    // Create a DragHandler. It will draw its rectangles on the given
    // VisualObject.

    void SetSizingParams (VObjDesc* vObj, const UI_Point& pt);
    // Tell the SizeHandler which VObjDesc must be resized and where on its
    // rectangle the user clicked.

    UI_CursorType CursorType (const UI_Point& pt);
    // Return the cursor type to be shown when the mouse is positioned at
    // {\tt pt}.
    
    const UI_Rectangle& Rectangle () const {return _rect;};
    // Return the currently-drawn rectangle.

protected:

    bool _MouseDown (UI_DisplaySurface& sfc, const UI_Point& p);
                    
    bool _MouseMove (UI_DisplaySurface& sfc, const UI_Point& p);
                    
    bool _MouseUp   (UI_DisplaySurface& sfc, const UI_Point& p);

    UI_Rectangle                _rect;
    VObjDesc*                   _vObj;
    VObjDesc::HitDirection      _dir;
};

#endif /* _draghndl_h_ */
