



#ifndef _dlgedit_h_ /* Sun Dec  3 15:23:31 1995 */
#define _dlgedit_h_


/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// The DialogEditor class maintains a set of VObjDesc objects, along with a
// subset which is the current selection. It manages all the set-specific
// operations. In a sense, it serves as model for the main window of the
// application.

#include <iostream.h>

#include "vobjdesc.h"
#include "vobjset.h"


#include "base/intset.h"
#include "ui/dialog.h"
#include "ui/font.h"

class AppWindow;

class DialogEditor {

public:
    DialogEditor (AppWindow* display);

    ~DialogEditor ();
    
    VObjSet& Store () {return _store;};

    VObjSet& Selection () {return _selection;};

    const CL_String& CurrentDialogName() const {return _dlgName;};
    
    UI_ViewID AllocateId ();
    
    VObjDesc* Add (UI_ViewType typ, const UI_Point& pt);

    long ClipboardSize () const {return _clipBoard.Size();};
    // Return the number of elements in the clipboard.
    
    void DoNew ();

    void DoFontChoice ();
    
    void DoProperties ();
    // Show the properties dialog for the currently-selected object.

    void DoReplicate ();

    void DoDelete ();
    // Delete the currently selected object

    void DoAlign ();
    // Show the alignment dialog and align the currently-selected objects

    void DoSize ();
    // Show the size dialog and resize the currently-selected objects

    void DoSave ();
    // Save the current configuration.

    void DoOpen ();
    // Open a file and read in a configuration.

    void DoTest ();
    
    void DoCut ();
    
    void DoCopy ();
    
    void DoPaste (const UI_Point& pt);


    void DoAbout ();


protected:
    AppWindow*            _client;
    VObjSet               _store;
    VObjSet               _selection;
    VObjSet               _clipBoard;
    CL_IntegerSet         _usedIdSet;
    CL_String             _dlgName;
    CL_String             _currentWorkingDir;
    CL_StringIntMap       _nameIdMap;
    UI_Dialog*            _propDlg;
    UI_FontDesc           _chosenFont;
    
    void _Replicate     (UI_Dialog* dlg);
    void _SetSizes      (UI_Dialog* dlg);
    void _SetAlignments (UI_Dialog* dlg);

    void _BuildIdMap    (istream&);
    CL_String _BuildVObjDesc (const char* descriptorLine,
                              VObjDesc& dsc);
    void _BuildVObjects (istream&);
    
    CL_String _BuildGroup (VObjDesc& d1, VObjSet&, CL_String& erMsg);
    CL_String _BuildButtonGroups (CL_String& desc, VObjSet&);
    CL_String _GroupName (VObjDesc&);
};


#endif /* _dlgedit_h_ */
