
#ifndef _appwin_h_ /* Sat Nov 25 12:05:59 1995 */
#define _appwin_h_



/*
 *
 *          Copyright (C) 1995, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1995. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */

// The AppWindow is the main window of the application. This object also
// maintains the DialogEditor instance.

#include "menudrv.h"
#include "draghndl.h"
#include "vobjset.h"
#include "dlgedit.h"

#include "base/intset.h"
#include "ui/dialog.h"
#include "ui/menu.h"

class AppWindow: public UI_CompositeVObject {

public:
    AppWindow ();
    ~AppWindow ();

    enum Mode {CreateMode, EditMode, PasteMode};
    
    void SetMode (Mode mode);

    DialogEditor& Editor () {return _editor;};
    
    void ShowVObj (VObjDesc&);
    // Draw the given VisualObject on the display.

    const char* ClassName () const {return "AppWindow";};
    
protected:

    void Initialize ();

    bool Paint (const UI_Rectangle&);
    
    bool ButtonDown (const UI_Point& pt, UI_MouseButton btn, bool, bool);

    bool MouseMove (const UI_Point&);

    bool DoubleClick (const UI_Point& pt, UI_MouseButton btn);
    
    MenuDriver    _driver;
    VObjDesc*     _vObjAtBtnDown;
    DragHandler*  _activeHandler;    // The handler currently active: one of
                                     // the following three
    MoveHandler*      _moveHandler;
    SizeHandler*      _sizeHandler;
    RectanglePainter* _rectPainter;

    DialogEditor      _editor;
    Mode          _currentMode;
    bool          _shiftKeyDown;
    
//     VObjSet               _store;
//     VObjSet               _selection;
//     CL_IntegerSet         _usedIdSet;
private:
    bool _RectPaintFinished ();
    bool _SizerFinished ();
    bool _MoverFinished ();
    void _DoSelect (const UI_Rectangle&);
    void _DrawHandles (const UI_Rectangle&);
    void _EraseSelectionHandles();
    void _DrawSelectionHandles();
    void _SetSizes (UI_Dialog*);
    void _SetAlignments (UI_Dialog*);
    void _Redraw ();
    void _Replicate (UI_Dialog*);
};


#endif /* _appwin_h_ */
