/*
 * Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

/*
 * TextDisplay - basic text displaying
 */

#include <InterViews/canvas.h>
#include <InterViews/font.h>
#include <InterViews/window.h>
#include <IV-2_6/InterViews/painter.h>
#include <IV-2_6/InterViews/shape.h>
#include <IV-2_6/InterViews/textdisplay.h>
#include <IV-X11/xcanvas.h>
#include <IV-X11/xwindow.h>

#include <OS/math.h>
#include <OS/memory.h>
#include <stdlib.h>
#include <string.h>

class TextLine {
public:
    TextLine();
    ~TextLine();

    void Style(TextDisplay*, int line, int first, int last, int style);
    void AddStyle(TextDisplay*, int line, int first, int last, int style);
    void RemoveStyle(TextDisplay*, int line, int first, int last, int style);

    void Insert(TextDisplay*, int line, int index, const char*, int count);
    void Delete(TextDisplay*, int line, int index, int count);
    void Replace(TextDisplay*, int line, const char*, int count);

    void Draw(TextDisplay*, int line, int first, int last);

    int Index(TextDisplay*, IntCoord x, boolean between);
    IntCoord Offset(TextDisplay*, int index);
    void Size(int);
    char* text;
    char* attr;
    int size;
    int lastchar;
    char prefix;
    char postfix;
};

TextDisplay::TextDisplay (boolean a) {
    painter = nil;
    canvas = nil;
    autosized = a;
    xmin = 0;
    xmax = 0;
    ymax = 0;
    ymin = 0;
    x0 = 0;
    y0 = 0;
    width = -1;
    lineheight = 1;
    tabwidth = 0;
    firstline = 0;
    lastline = 1;
    topline = 0;
    bottomline = -1;
    widestline = 0;
    lines = nil;
    maxlines = 0;
    lines = new TextLine*;
    lines[0] = new TextLine;
}

TextDisplay::~TextDisplay () {
    for (int i = firstline; i <= lastline; ++i) {
        delete Line(i, false);
    }
    delete lines;
}

void TextDisplay::Scroll (int line, IntCoord x, IntCoord y) {
}

void TextDisplay::Draw (Painter* p, Canvas* c) {
    painter = p;
    canvas = c;
}

void TextDisplay::LineHeight (IntCoord height) {
    lineheight = height;
}

void TextDisplay::TabWidth (IntCoord width) {
    tabwidth = width;
}

void TextDisplay::Resize (IntCoord xn, IntCoord yn, IntCoord xx, IntCoord yx) {
    xmin = xn;
    ymin = yn;
    xmax = xx;
    ymax = yx;
    bottomline = topline + (ymax+y0 - ymin + 1) / lineheight - 1;
}

void TextDisplay::Bounds (IntCoord& xn, IntCoord& yn, IntCoord& xx, IntCoord& yx) {
    xn = xmin;
    yn = ymin;
    xx = xmax;
    yx = ymax;
}

void TextDisplay::Redraw (IntCoord, IntCoord, IntCoord, IntCoord)
{
    if (canvas != nil)
    {
        WindowRep*  w = canvas->rep()->window_->rep();
        /* Let base class do the drawing */
        w->last_event_processed_ = false;

        if(w->prepared_ == false)
        {
            w->prepared_ = true;
            WinSetWindowText( w->xwindow_, (PSZ) lines[0]->text);
        }
    }
}


void TextDisplay::Size (int first, int last)
{
}

TextLine* TextDisplay::Line (int line, boolean create)
{
    return lines[0];
}


int TextDisplay::Index (int line)
{
    return line - firstline;
}

void TextDisplay::InsertLinesAfter (int line, int count) {
}

void TextDisplay::InsertLinesBefore (int line, int count) {
}

void TextDisplay::DeleteLinesAfter (int line, int count) {
}

void TextDisplay::DeleteLinesBefore (int line, int count) {
}

void TextDisplay::InsertText (int l, int i, const char* t, int c)
{
    ReplaceText(0, t, 0);
}

void TextDisplay::DeleteText (int l, int i, int c) {
}

void TextDisplay::ReplaceText (int l, const char* t, int c)
{
   lines[0]->text = (char*)t;
   Redraw(0,0,0,0);
}

void TextDisplay::Style (int l1, int i1, int l2, int i2, int style) {
}

void TextDisplay::AddStyle (int l1, int i1, int l2, int i2, int style) {
}

void TextDisplay::RemoveStyle (int l1, int i1, int l2, int i2, int style) {
}

void TextDisplay::CaretStyle (int style) {
}

void TextDisplay::Caret (int line, int index) {
}

void TextDisplay::HideCaret () {
}

void TextDisplay::ShowCaret () {
}


IntCoord TextDisplay::Width ()
{
    return 50;
}

IntCoord TextDisplay::Height () {
    return 20;
}

int TextDisplay::LineNumber (IntCoord y)
{
    return 0;
}


int TextDisplay::LineIndex (int line, IntCoord x, boolean between)
{
    return 0;
}

IntCoord TextDisplay::Base (int line)
{
    return ymax + y0 - line * lineheight - (lineheight - 1);
}

IntCoord TextDisplay::Top (int line) {
    return ymax + y0 - line * lineheight;
}

IntCoord TextDisplay::Left (int line, int index) {
    TextLine* l = Line(line, false);
    if (l == nil) {
        return xmin + x0;
    } else {
        return xmin + x0 + l->Offset(this, index);
    }
}

IntCoord TextDisplay::Right (int line, int index) {
    TextLine* l = Line(line, false);
    if (l == nil) {
        return xmin + x0;
    } else {
        return xmin + x0 + l->Offset(this, index+1) - 1;
    }
}

TextLine::TextLine () {
    size = 0;
    text = nil;
    attr = nil;
    prefix = 0;
    postfix = 0;
    lastchar = -1;
    Size(0);
}

TextLine::~TextLine () {
    delete text;
    delete attr;
}

IntCoord TextLine::Offset (TextDisplay* display, int index)
{
    return 10;
}


int TextLine::Index (TextDisplay* display, IntCoord x, boolean between)
{
    return 5;
}

void TextLine::Size (int last) {
}

void TextLine::Style (
    TextDisplay* display, int line, int first, int last, int style
) {
}

void TextLine::AddStyle (
    TextDisplay* display, int line, int first, int last, int style
) {
}

void TextLine::RemoveStyle (
    TextDisplay* display, int line, int first, int last, int st
) {
}

void TextLine::Insert (
    TextDisplay* display, int line, int index, const char* s, int count
)
{
    text = (char*)s;
}

void TextLine::Delete (
    TextDisplay* display, int line, int index, int count
) {
}

void TextLine::Replace (
    TextDisplay* display, int line, const char* t, int c
) {
    text = (char*)t;
    Draw(display, line, -1, lastchar+1);
}

void TextLine::Draw (
    TextDisplay* display, int line, int first, int last
)
{
}
