#include "filechoo.h"
#include "strbrows.h"
#include "stredit.h"
#include "sttext.h"
#include "button.h"
#include "event.h"




static void StripBracket( char* selname);


extern "C" {

#include <os2.h>
#include <string.h>
#include <stdlib.h>
}


FileChooser::FileChooser(
               Window*     owner,
               const char* title,
               const char* dir,
               const char* filemask,
               b2 w, b2 h) : ( owner, w, h, title)

{
   strcpy( fmask, filemask ? filemask : "");
   dmask = dir;

   cur_dir = new StaticText( 100, 30, dmask, OV_LEFTJUSTIFY);
   dir_list = new StringBrowser( 140, 140, "StringBrowser", 0);
   file_list = new StringBrowser( 140, 140, "StringBrowser", 0);
   file_name = new StringEditor( 90, 25, fmask,'q', StringEditorFrame);


   Insert( cur_dir, 10, 225);
   Insert( dir_list, 10, 70);
   Insert( file_list, 160, 70);
   Insert( file_name, 160, 225);

   Insert( new Button( 80,
                30,
                "OK",
                OK_BUTTON),
                10, 20);

   Insert( new Button( 80,
                30,
                "Cancel",
                CANCEL_BUTTON),
                100, 20);

   Refresh(fmask);
}


bool FileChooser::Init( void* w)
{
   Dialog::Init(w);
   Refresh(fmask);
   return 1;
}



FileChooser::HandleEvent( Event& ev)
{
   const char* edit_text;
   const char* filename;
   bool        wild;
   int   done = TRUE;

   switch( ev.eventType)
   {
      case CommandMsg:
         if( ev.id == OK_BUTTON)
         {
            edit_text = file_name -> Text();

            if( SetCurrentDisk( edit_text) != -1)
            {
               const char* pathname = DirectoryFromPath(edit_text);

               if( pathname)
               {
//                  SetDirectory(pathname);
               }

               /* Obtain filename and flag to say if wildcards present */


               filename = FileFromPath( edit_text, &wild);

               if (wild)
               {
                  FillDirList();
                  FillFileList(filename);

                  /* Set new file name (wild) in the edit control */
                  file_name -> Message(filename);
               }
               else
               {
                  strcpy( selection, filename);
                  Dismiss(OK_BUTTON);
               }
            }
         }

         else if( ev.id == CANCEL_BUTTON)
         {
            selection[0] = '\0';
            Dismiss(ev.id);
         }

         break;

      case ControlMsg:
      {
         switch( ev.GetControlEvent()->eventType)
         {
            case BrowserClicked:
               Clicked(ev);
               break;

            case BrowserSelected:
               Selected(ev);
               break;

            default:
               break;
         }

         break;
      }

      default:
         done = FALSE;
         break;
   }/*SWITCH*/
   return done;
}


static void StripBracket( char* selname)
{
   if (*selname == '[')
   {
      /* Strip square brackets from a disk/path name */
      strcpy(selname, &selname[1]);
      selname[strlen(selname) - 1] = '\0';
   }
}




void FileChooser::Clear()
{
   /* Clear directory and file lists */
   dir_list -> Clear();
   file_list -> Clear();
}



/*
** Given a path string, return the largest substring
** (starting from the beginning of _p_a_t_h) that represents a
** valid path.  The substring is returned in a static
** buffer and should be copied before use.
*/


const char* FileChooser::DirectoryFromPath( const char* path)
{
   static char  newpath[128];              /* extracted path name             */
   char*  temp;                          /* temporary pointer to path string*/
   int    dummy;                         /* for use calling ED_FileFromPath */
   USHORT pathlen;                       /* length of path                  */

   /* Skip past any blanks at beginning of string */
   while (*path == ' ')
      path++;

   /* Skip past disk name (if any) */
   if (path[1] == ':')
      path += 2;

   /* Get pointer to filename in the string (end of path)                   */
   temp = FileFromPath(path, &dummy);

   /* If filename start == pathname start then there is no path */
   if ( temp == (char*)path)
   {
      /* Set path length to 0 to signify that none is present               */
      pathlen = 0;
      return(NULL);
   }

   else
   {
      /* Calculate path length                                              */
      if ( (char*) (path + 1) == temp)
         pathlen = temp - (char*)path;
      else
         pathlen = temp - (char*) path - 1;

      strcpy(newpath, path);
      newpath[pathlen] = '\0';
      return(newpath);
   }
}



void FileChooser::Clicked( Event& ev)
{
   if( file_list -> Cid() == ev.id)
   {
      /*
      ** A file list box item has been selected, get selection
      ** string from file listbox and put it in
      ** the string editor and also into our selection.
      */
      file_name->Message(file_list->String(file_list->Selection(0)));
      strcpy( selection, file_name->Text());
   }

   else if( dir_list -> Cid() == ev.id)
   {
      bool  wild;
      char  edit_text[128];

      strcpy( edit_text , file_name->Text());

      /* If the filename is wild then make it new default */
      const char* filename = FileFromPath( edit_text, &wild);

      if (wild)
      {
         strcpy( fmask, filename);
      }

      /* Get selected dir/drive name */
      strcpy( edit_text, dir_list -> String(dir_list->Selection(0)));

      StripBracket(edit_text);

      /* If directory selected, add \ to it */
      if ( edit_text[1] != ':')
         strcat( edit_text,  "\\");

      /* Set new name as default */
      strcat( edit_text , fmask);

      /* Put adjusted filename back into edit control */
      file_name -> Message(edit_text);
   }
}


void FileChooser::Selected( Event& ev)
{
   char  newname[128];
   const char* edit_text;

   /* Obtain text string from edit control */
   edit_text = file_name->Text();
   strcpy( selection, edit_text);


   if( file_list -> Cid() == ev.id)
   {
      /**********************************************/
      /* Filename selected - return from dialog box */
      /**********************************************/
//      strcpy( selection, newname);
      Dismiss(OK_BUTTON);
   }

   else if( dir_list -> Cid() == ev.id)
   {
      /************************************************/
      /* Disk/Directory selected - refresh both lists */
      /************************************************/
      strcpy( newname, dir_list -> String( dir_list->Selection(0)));
      StripBracket(newname);

      if(newname[1] == ':')
      {
         SetCurrentDisk(*newname - 64);
         strcpy( selection, &selection[strlen(newname)]);
      }
      else
      {
         SetCurrentDirectory(newname);
         strcpy( selection, &selection[strlen(newname)+1]);
      }

      Refresh(selection);
   }
}


const char* FileChooser::Selection()
{
   return (const char*) selection;
}

