(* Copyright (c) 1996 xTech Ltd, Russia. All Rights Reserved. *)

(* Sample tool for XDS IDE: Finding procedure headings        *)

<*+ M2EXTENSIONS *>

MODULE FindProc;

IMPORT SYSTEM;
IMPORT ProgramArgs, TextIO, STextIO, IOChan, RndFile, IOResult;
IMPORT Strings;

IMPORT IDE := xShell;


VAR
  ide  : BOOLEAN;
  name : ARRAY [0..255] OF CHAR;
  file : RndFile.ChanId;
  size : RndFile.FilePos;
  line : CARDINAL;

PROCEDURE FatalError(s: ARRAY OF CHAR);
BEGIN
  IF ide THEN
    IDE.String(s);
  ELSE
    STextIO.WriteString(s);
    STextIO.WriteLn;
  END;
  HALT;
END FatalError;

PROCEDURE OpenFile;
VAR
  res  : RndFile.OpenResults;
BEGIN
  IF NOT ProgramArgs.IsArgPresent() THEN
    FatalError("Too few arguments");
  END;
  TextIO.ReadToken(ProgramArgs.ArgChan(),name);
  RndFile.OpenOld(file,name,RndFile.text,res);
  IF res <> RndFile.opened THEN
    FatalError("Failed to open a file");
  END;
END OpenFile;

PROCEDURE ReadFile;
VAR
  buf   : ARRAY [0..255] OF CHAR;
  found : BOOLEAN;
  pos   : CARDINAL;
BEGIN
  line := 0;
  size := RndFile.EndPos(file);
  IF ide THEN
    IDE.Comment(name);
    IDE.StartJob("Scanning",size);
  END;
  LOOP
    TextIO.ReadString(file,buf);
    CASE IOResult.ReadResult(file) OF
    |IOResult.allRight:
      Strings.FindNext('PROCEDURE', buf, 0, found, pos);
      IF found THEN
        IF ide THEN
          IDE.Error(IDE.MSG_WARNING,pos,line,name,buf);
          IDE.String(buf);
          IDE.String(15C+12C);
        END;
      END;
    |IOResult.endOfLine:
      TextIO.SkipLine(file); INC(line);
    |IOResult.endOfInput:
      EXIT
    END;
    IF ide THEN
      IDE.Progress(line,-VAL(INTEGER,RndFile.CurrentPos(file)));
    END;
  END;
END ReadFile;

PROCEDURE CloseFile;
BEGIN
  RndFile.Close(file);
END CloseFile;

BEGIN
  ide := IDE.Start();
  IF ide THEN
    IDE.TurnSortingOff;
    IDE.Caption("Finding procedures...");
  END;
  OpenFile;
  ReadFile;
  CloseFile;
  IF ide THEN
    IDE.Caption("Done");
  END;
FINALLY
  IF ide THEN IDE.Finish; END;
END FindProc.
