#define INCL_WINSHELLDATA

#include <os2.h>
#include <stdlib.h>

#include "tcl.h"

/*
 *----------------------------------------------------------------------
 *
 * Tcl_ProfileCmd --
 *
 *	This procedure is invoked to process the "fileini" Tcl/2 command.
 *	See the user documentation for details on what it does.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *----------------------------------------------------------------------
 */
	/* ARGSUSED */
int Tcl_ProfileCmd(ClientData dummy, Tcl_Interp *interp, int argc, char **argv)
{
    int    c, result, iToken;
    HINI   hini;
    enum   token = {GETKEY, SETKEY, DELKEY, GETAPPKEYS, GETAPPS, DELAPP};
    char*  pPrfName;
    size_t length;
    struct stat buffer;
    
    if (argc < 3) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		" option name ?arg ...?\"", (char *) NULL);
	return TCL_ERROR;
    }

    c = argv[1][0];
    length = strlen(argv[1]);
    result = TCL_OK;
    
    /*
     * First handle operations on the file name.
     */
    pPrfName = Tcl_TildeSubst(interp, argv[2], &buffer);
    if (pPrfName == NULL) {
	result = TCL_ERROR;
	goto done;
    }
    
    if (strncmp(argv[1], "getkey", length) == 0) iToken = GETKEY;
     else if (strncmp(argv[1], "setkey", length) == 0) iToken = SETKEY;
      else if (strncmp(argv[1], "delkey", length) == 0) iToken = DELKEY;
       else if (strncmp(argv[1], "getappkeys", length) == 0) iToken = GETAPPKEYS;
        else if (strncmp(argv[1], "getapps", length) == 0) iToken = GETAPPS;
         else if (strncmp(argv[1], "delapp", length) == 0) iToken = DELAPP;
          else {
              Tcl_AppendResult(interp, "bad option \"", argv[1],
		"\": should be delapp, delkey, getappkeys, getapps,getkey or setkey"
		(char *) NULL);
	      result = TCL_ERROR;
	      goto done;
          }
    /* parameters checking... */
    switch (iToken) {
        case GETKEY:
            if (argc != 5) {
                Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		    " ", argv[1], " name\"", (char *) NULL);
	        result = TCL_ERROR;
	        goto done;
	    }
	    break;
    }
    
    hini = PrfOpenProfile(0, pPrfName);
    if (hini == 0) {
        Tcl_AppendResult(interp, "couldn't open "", argv[2],
	    "": No application profile", (char *) NULL);
        result = TCL_ERROR;
        goto done;
    }
    
    /* execution... */
    result = TCL_ERROR;
    switch (iToken)
    {
        case GETKEY:
            if (PrfQueryProfileSize(hini, argv[3], argv[4], &keylen)) {
                char *p = calloc(keylen+1, 1);
                if (PrfQueryProfileString(hini, argv[3], argv[4], "", p, keylen)) {
                   Tcl_SetResult(interp, p, TCL_VOLATILE);
                   result = TCL_OK
                }
        }
    }

    done:
    Tcl_DStringFree(&buffer);
    return result;
}