#define	KCL_SELF		"/usr2/kcl2/unixport/saved_kcl"
#define	SYSTEM_DIRECTORY	"/usr2/kcl2/unixport/"

#include <stdio.h>
#include <signal.h>

#define	COMSIZ	1024

main(argc, argv)
int argc;
char *argv[];
{
	int in[2];
	int out[2];
	char command[COMSIZ];
	char buf[4];

	if (argc != 2) {
		fprintf(stderr, "Arg count.\n");
		exit(1);
	}
	printf("Compiling %s.lsp\n", argv[1]);
	fflush(stdout);
	pipe(in);
	pipe(out);
	if (in[1] != 4 || out[0] != 5) {
		fprintf(stderr, "Can't get a pipe.\n");
		exit(1);
	}
	fflush(stdout);
	if (fork() != 0) {
		close(in[0]);
		close(out[1]);
		if (execl(KCL_SELF, KCL_SELF,
			  SYSTEM_DIRECTORY,
			  argv[1], argv[1], "U1000",
			  0) < 0) {
			fprintf(stderr, "Can't exec KCL.\n");
			exit(1);
		}
	}
	signal(SIGINT, SIG_IGN);
	close(in[1]);
	close(out[0]);
	for (;;) {
		if (read(in[0], command, COMSIZ) <= 0)
			exit(0);
		buf[0] = system(command);
		write(out[1], buf, 1);
	}
}
