/*
(C) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
*/

#ifdef DGUX
#include <stdio.h>
#endif

/*
	fasl loader parameter definition
*/
#define FAS_HEADER_LEN		3	/* header word length */
#define FAS_HEADER_BLEN		6	/* header byte length */
#define FAS_DATA_LEN		7	/* data block length */
#define FAS_DATA_BLEN		14	/* data block byte length */
#define MAX_TITLE		32	/* title max length */
#define MAX_SYMBOL		32	/* symbol max length */
#define MAX_SYS_PART		7	/* max system partition no */
#define EX_RELOC		017	/* extended relocation */
#define BIT_RELOC		016	/* extended bit relocation */

/* Define the offsets of the various words in the FASL blocks. Certain
   parts of different ob blocks are quite similar. This includes the
   block header, the name descriptors and the relocation entries. These
   are defined as follows:					*/

/* block header */

struct fas_hdr {
 	short	hdr_typ;	/* block type */
	short	hdr_num;	/* block number */
	short	hdr_len;	/* block length including header */
	};

/* name descriptor */

struct fas_name {
	short	name_len;	/* name length */
	short	name_ptr;	/* byte offset */
	};

/* standard symbol or dictionary entry */

struct fas_std {
	short	std_disp;	/* displacement */
	short	std_reloc;	/* relocation */
	};

/* extended symbol entry */

struct fas_sym {
	short	sym_base;	/* relocation base */
	short	sym_reloc;	/* relocation */
	long	sym_disp;	/* displacement */
	};

/* extended dictionary entry */

struct fas_dict {
	short	dict_data;	/* word offset */
	short	dict_reloc;	/* relocation */
	short	dict_base;	/* relocation base */
	};

/* bit relocation entry */

struct fas_bit {
	short	bit_data;	/* word offset */
	short	bit_reloc;	/* relocation */
	short	bit_base;	/* relocation base */
	short	bit_fields;	/* bit field description */
	};

/* data block */

struct fas_data {
	short	data_words;	/* word count */
	long	data_repeat;	/* repeat count */
	short	data_base;	/* relocation base */
	short	data_reloc;	/* relocation operation */
	long	data_disp;	/* data displacement */
	};

/* title block */

struct fas_titl {
	short	titl_rev;	/* revision */
	short	titl_len;	/* title length */
	short	titl_ptr;	/* byte offset */
	};

/* end block */

struct fas_end {
	short	end_base;	/* relocation base */
	short	end_reloc;	/* relocation */
	long	end_start;	/* start address */
	};

/* unlabelled common block */

struct fas_uncom {
	long	uncom_len;	/* length */
	short	uncom_reloc;	/* relocation */
	};

/* external symbols block */

struct fas_ext {
	short	ext_num;	/* number of symbols */
	};

/* entry and local symbols block */

struct fas_ent {
	short	ent_count;	/* number of entries */
	};

/* entry descriptor */

struct fas_entd {
	short	entd_len;	/* length */
	short	entd_ptr;	/* name pointer */
	short	entd_base;	/* base */
	short	entd_reloc;	/* relocation */
	long	entd_disp;	/* displacement */
	};

/* partition difinition block */

struct fas_pat {
	short	pat_count;	/* number of patitions */
	};

/* partition descriptor */

struct fas_patd {
	short	patd_flag;	/* various flags */
	short	patd_nlen;	/* partition name length */
	short	patd_nptr;	/* partition name pointer */
	long	patd_len;	/* partition length */
	};

/* revision block */

struct fas_rev {
	short	rev_lrev;	/* link revision number */
	short	rev_count;	/* number of revision descriptors */
	};

/* revision descriptor */

struct fas_revd {
	short	revd_btyp;	/* block type */
	short	revd_brev;	/* block revision */
	};

/* module revision block */

struct fas_mrev {
	long	mrev_rev;	/* module revision */
	};

/* filler block */

struct fas_fil {
	short	fil_data;	/* data filied */
	};

/* alignment block */

struct fas_aln {
	short	aln_base;	/* relocation base */
	short	aln_power;	/* alignment factor */
	};

/*
	partition table definition
*/

/*
	define global variables for FASL loader
*/

struct part_table {
	short	part_no;	/* partition number */
	long	part_len;	/* partition length */
	long	part_addr;	/* base address */
	short	part_align;	/* alignment */
	short	part_global;	/* global or local flag */
	short	part_symbol;	/* partition or ext. symbol flag */
	char	part_name[MAX_SYMBOL + 1];	/* partition name */
	};

/*
	block type defnition
*/
enum block_types {
	DATA_BLOCK = 0,	/* data block */
	TITL_BLOCK,	/* title block */
	END_BLOCK,	/* end block */
	UNCOM_BLOCK,	/* unlabeled common */
	EXT_BLOCK,	/* external */
	ENT_BLOCK,	/* entry */
	LOCAL_BLOCK,	/* local entry, ignored */
	LIBS_BLOCK,	/* library start block, unexpected */
	AIB_BLOCK,	/* address infoamtion block, unexpected */
	SYS1_BLOCK,	/* reserved, unexpected */
	TASK_BLOCK,	/* unexpected */
	SYS2_BLOCK,	/* reserved, unexpected */
	COMM_BLOCK,	/* labeled common, unexpected */
	SYS3_BLOCK,	/* reserved, unexpected */
	DEBS_BLOCK,	/* debugger symbol, ignored */
	DEBL_BLOCK,	/* debugger line, ignored */
	LTITL_BLOCK,	/* line title, ignored */
	LIBE_BLOCK,	/* library end, unexpected */
	SYS4_BLOCK,	/* reserved, unexpected */
	PAT_BLOCK,	/* partition block */
	SYS5_BLOCK,	/* reserved, unexpected */
	SYS6_BLOCK,	/* reserved, unexpected */
	REV_BLOCK,	/* revision block */
	FIL_BLOCK,	/* filler block unexpected */
	MREV_BLOCK,	/* module revision block */
	ALN_BLOCK	/* allinment block */
	};

/*
	for easy reference
*/
typedef struct fas_hdr		*FAS_HDR_P;
typedef struct fas_name		*FAS_NAME_P;
typedef struct fas_std		*FAS_STD_P;
typedef struct fas_sym		*FAS_SYM_P;
typedef struct fas_dict		*FAS_DICT_P;
typedef struct fas_bit		*FAS_BIT_P;
typedef struct fas_data		*FAS_DATA_P;
typedef struct fas_titl		*FAS_TITL_P;
typedef struct fas_end		*FAS_END_P;
typedef struct fas_uncom	*FAS_UNCOM_P;
typedef struct fas_ext		*FAS_EXT_P;
typedef struct fas_ent		*FAS_ENT_P;
typedef struct fas_entd		*FAS_ENTD_P;
typedef struct fas_pat		*FAS_PAT_P;
typedef struct fas_patd		*FAS_PATD_P;
typedef struct fas_rev		*FAS_REV_P;
typedef struct fas_revd		*FAS_REVD_P;
typedef struct fas_mrev		*FAS_MREV_P;
typedef struct fas_fil		*FAS_FIL_P;
typedef struct fas_aln		*FAS_ALN_P;

typedef struct part_table	*PART_TABLE_P;

/*
	parameter definition
*/

#define TRUE		1
#define FALSE		0
#define FAS_BUFF_LEN	2048
#define FAS_MAP_SIZE	1024

#define R_MASK		0177400	/* mask right byte */
#define L_MASK		0000377	/* mask left byte */
#define BLOCK_TYPE	0000377 /* block type */
#define OVER_BIT	0004000 /* suppress overwrite message */
#define RELOC_OP	0000017	/* relocation operation */
#define RELOC_OP_EX	0177760	/* extended relocation operation */
#define PAT_ALN		0000740 /* partition alinment power */
#define PAT_NREL	0000010 /* long or short NREL */
#define PAT_BASE	0000004 /* default or common base */
#define BIT_START	0177400 /* bit field start position */
#define BIT_LEN		0000377 /* bit field length */

#define PAT_ALN_S	5	/* partition alignment shift width */
#define PAT_BASE_S	2	/* partition base shift width */
#define RELOC_OP_S	4	/* extended relocation shift width */
#define BIT_FIELD_S	10	/* bit field start pos shift width */

#define FAS_TABLES_IN_REC	\
			(FAS_BUFF_LEN / sizeof(struct part_table))

#define FAS_ADDRS_IN_REC	(FAS_BUFF_LEN / sizeof(int))

#ifdef DGUX

#define fasl_rpos() fseek(faslin, 0, 0)
#define fasl_skip(count) fseek(faslin, (count), 0)

#define FAS_HSIZE		8
#define SYMBOL_TABLE_MAX	24

struct sym_header {
	short	count;
	short	npage;
};

struct sym_entry {
	int	value;
	short	blength;
};

#endif
