;;; LFUN_LIST   Database for system functions.
;;;
;; (c) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
;; Copying of this file is authorized to users who have executed the true and
;; proper "License Agreement for Kyoto Common LISP" with SIGLISP.

(in-package 'compiler)

(defsysfun 'SI:RPLACA-NTHCDR "siLrplaca_nthcdr" nil nil nil nil)
(defsysfun 'SI:LIST-NTH "siLlist_nth" nil nil nil nil)
(defsysfun 'SI:MAKE-PURE-ARRAY "siLmake_pure_array" nil 'array nil nil)
(defsysfun 'SI:MAKE-VECTOR "siLmake_vector" nil 'vector nil nil)
;(defsysfun 'SI:MAKE-BITVECTOR "siLmake_bitvector" nil 'bit-vector nil nil)
(defsysfun 'AREF "Laref" '(array fixnum fixnum fixnum) nil nil nil)
(defsysfun 'SI:ASET "siLaset" '(array) nil nil nil)
(defsysfun 'ARRAY-ELEMENT-TYPE "Larray_element_type" '(array) nil nil nil)
(defsysfun 'ARRAY-RANK "Larray_rank" '(array) 'fixnum nil nil)
(defsysfun 'ARRAY-DIMENSION "Larray_dimension" '(array fixnum) 'fixnum nil nil)
(defsysfun 'ADJUSTABLE-ARRAY-P "Ladjustable_array_p" '(array) nil nil t)
(defsysfun 'SI:DISPLACED-ARRAY-P "siLdisplaced_array_p" '(array) nil nil t)
(defsysfun 'SVREF "Lsvref" '(simple-vector fixnum) nil nil nil)
(defsysfun 'SI:SVSET "siLsvset" '(simple-vector fixnum t) nil nil nil)
(defsysfun 'FILL-POINTER "Lfill_pointer" '(vector) 'fixnum nil nil)
(defsysfun 'SI:FILL-POINTER-SET "siLfill_pointer_set" '(vector fixnum) 'fixnum nil nil)
(defsysfun 'SI:REPLACE-ARRAY "siLreplace_array" nil nil nil nil)
(defsysfun 'SET "Lset" '(symbol t) nil nil nil)
(defsysfun 'SI:FSET "siLfset" '(symbol t) nil nil nil)
(defsysfun 'MAKUNBOUND "Lmakunbound" '(symbol) nil nil nil)
(defsysfun 'FMAKUNBOUND "Lfmakunbound" '(symbol) nil nil nil)
(defsysfun 'SI:ERROR-SET "siLerror_set" nil nil nil nil)
(defsysfun 'STANDARD-CHAR-P "Lstandard_char_p" '(character) nil nil t)
(defsysfun 'GRAPHIC-CHAR-P "Lgraphic_char_p" '(character) nil nil t)
(defsysfun 'STRING-CHAR-P "Lstring_char_p" '(character) nil nil t)
(defsysfun 'ALPHA-CHAR-P "Lalpha_char_p" '(character) nil nil t)
(defsysfun 'UPPER-CASE-P "Lupper_case_p" '(character) nil nil t)
(defsysfun 'LOWER-CASE-P "Llower_case_p" '(character) nil nil t)
(defsysfun 'BOTH-CASE-P "Lboth_case_p" '(character) nil nil t)
(defsysfun 'DIGIT-CHAR-P "Ldigit_char_p" '(character) nil nil nil)
(defsysfun 'ALPHANUMERICP "Lalphanumericp" '(character) nil nil t)
(defsysfun 'CHAR= "Lchar_eq" '(character character) nil nil t)
(defsysfun 'CHAR/= "Lchar_neq" '(character character) nil nil t)
(defsysfun 'CHAR< "Lchar_l" '(character character) nil nil t)
(defsysfun 'CHAR> "Lchar_g" '(character character) nil nil t)
(defsysfun 'CHAR<= "Lchar_le" '(character character) nil nil t)
(defsysfun 'CHAR>= "Lchar_ge" '(character character) nil nil t)
(defsysfun 'CHAR-EQUAL "Lchar_equal" '(character character) nil nil t)
(defsysfun 'CHAR-NOT-EQUAL "Lchar_not_equal" '(character character) nil nil t)
(defsysfun 'CHAR-LESSP "Lchar_lessp" '(character character) nil nil t)
(defsysfun 'CHAR-GREATERP "Lchar_greaterp" '(character character) nil nil t)
(defsysfun 'CHAR-NOT-GREATERP "Lchar_not_greaterp" '(character character) nil nil t)
(defsysfun 'CHAR-NOT-LESSP "Lchar_not_lessp" '(character character) nil nil t)
(defsysfun 'CHARACTER "Lcharacter" nil 'character nil nil)
(defsysfun 'CHAR-CODE "Lchar_code" '(character) 'fixnum nil nil)
(defsysfun 'CHAR-BITS "Lchar_bits" '(character) 'fixnum nil nil)
(defsysfun 'CHAR-FONT "Lchar_font" '(character) 'fixnum nil nil)
(defsysfun 'CODE-CHAR "Lcode_char" '(fixnum) 'character nil nil)
(defsysfun 'MAKE-CHAR "Lmake_char" '(character fixnum fixnum fixnum) 'character nil nil)
(defsysfun 'CHAR-UPCASE "Lchar_upcase" '(character) 'character nil nil)
(defsysfun 'CHAR-DOWNCASE "Lchar_downcase" '(character) 'character nil nil)
(defsysfun 'DIGIT-CHAR "Ldigit_char" '(fixnum character fixnum) 'character nil nil)
(defsysfun 'CHAR-INT "Lchar_int" '(character) 'fixnum nil nil)
(defsysfun 'INT-CHAR "Lint_char" '(fixnum) 'character nil nil)
(defsysfun 'CHAR-NAME "Lchar_name" '(character) 'symbol nil nil)
(defsysfun 'NAME-CHAR "Lname_char" '(symbol) 'character nil nil)
(defsysfun 'CHAR-BIT "Lchar_bit" '(character) 'fixnum nil nil)
(defsysfun 'SET-CHAR-BIT "Lset_char_bit" '(character t fixnum) 'character nil nil)
(defsysfun 'SI:SPECIALP "siLspecialp" nil nil nil t)
(defsysfun 'ERROR "Lerror" nil nil nil nil)
(defsysfun 'CERROR "Lcerror" nil nil nil nil)
(defsysfun 'APPLY "Lapply" nil nil nil nil)
(defsysfun 'FUNCALL "Lfuncall" nil nil nil nil)
(defsysfun 'EVAL "Leval" nil nil nil nil)
(defsysfun 'EVALHOOK "Levalhook" nil nil nil nil)
(defsysfun 'APPLYHOOK "Lapplyhook" nil nil nil nil)
(defsysfun 'CONSTANTP "Lconstantp" nil nil nil t)
(defsysfun 'MAKE-SYNONYM-STREAM "Lmake_synonym_stream" nil nil nil nil)
(defsysfun 'MAKE-BROADCAST-STREAM "Lmake_broadcast_stream" nil nil nil nil)
(defsysfun 'MAKE-TWO-WAY-STREAM "Lmake_two_way_stream" nil nil nil nil)
(defsysfun 'MAKE-ECHO-STREAM "Lmake_echo_stream" nil nil nil nil)
(defsysfun 'SI:OUTPUT-STREAM-STRING "siLoutput_stream_string" nil nil nil nil)
(defsysfun 'STREAMP "Lstreamp" nil nil nil t)
(defsysfun 'INPUT-STREAM-P "Linput_stream_p" nil nil nil t)
(defsysfun 'OUTPUT-STREAM-P "Loutput_stream_p" nil nil nil t)
(defsysfun 'STREAM-ELEMENT-TYPE "Lstream_element_type" nil nil nil nil)
(defsysfun 'CLOSE "Lclose" nil nil nil nil)
(defsysfun 'OPEN "Lopen" nil nil nil nil)
(defsysfun 'FILE-POSITION "Lfile_position" nil nil nil nil)
(defsysfun 'FILE-LENGTH "Lfile_length" nil nil nil nil)
(defsysfun 'LOAD "Lload" nil nil nil nil)
(defsysfun 'SI:COPY-STREAM "siLcopy_stream" nil nil nil nil)
(defsysfun 'TRUENAME "Ltruename" nil nil nil nil)
(defsysfun 'USER-HOMEDIR-PATHNAME "Luser_homedir_pathname" nil nil nil nil)
(defsysfun 'RENAME-FILE "Lrename_file" nil nil nil nil)
(defsysfun 'DELETE-FILE "Ldelete_file" nil nil nil nil)
(defsysfun 'PROBE-FILE "Lprobe_file" nil nil nil nil)
(defsysfun 'FILE-WRITE-DATE "Lfile_write_date" nil nil nil nil)
(defsysfun 'FILE-AUTHOR "Lfile_author" nil nil nil nil)
(defsysfun 'DIRECTORY "Ldirectory" nil nil nil nil)
(defsysfun 'FORMAT "Lformat" '(t string) nil nil nil)
(defsysfun 'MAKE-HASH-TABLE "Lmake_hash_table" nil nil nil nil)
(defsysfun 'HASH-TABLE-P "Lhash_table_p" nil nil nil t)
(defsysfun 'GETHASH "Lgethash" nil nil nil nil)
(defsysfun 'REMHASH "Lremhash" nil nil nil nil)
(defsysfun 'MAPHASH "Lmaphash" nil nil nil nil)
(defsysfun 'CLRHASH "Lclrhash" nil nil nil nil)
(defsysfun 'HASH-TABLE-COUNT "Lhash_table_count" nil nil nil nil)
(defsysfun 'SXHASH "Lsxhash" nil nil nil nil)
(defsysfun 'SI:HASH-SET "siLhash_set" nil nil nil nil)
(defsysfun 'CAR "Lcar" nil nil nil nil)
(defsysfun 'CDR "Lcdr" nil nil nil nil)
(defsysfun 'CAAR "Lcaar" nil nil nil nil)
(defsysfun 'CADR "Lcadr" nil nil nil nil)
(defsysfun 'CDAR "Lcdar" nil nil nil nil)
(defsysfun 'CDDR "Lcddr" nil nil nil nil)
(defsysfun 'CAAAR "Lcaaar" nil nil nil nil)
(defsysfun 'CAADR "Lcaadr" nil nil nil nil)
(defsysfun 'CADAR "Lcadar" nil nil nil nil)
(defsysfun 'CADDR "Lcaddr" nil nil nil nil)
(defsysfun 'CDAAR "Lcdaar" nil nil nil nil)
(defsysfun 'CDADR "Lcdadr" nil nil nil nil)
(defsysfun 'CDDAR "Lcddar" nil nil nil nil)
(defsysfun 'CDDDR "Lcdddr" nil nil nil nil)
(defsysfun 'CAAAAR "Lcaaaar" nil nil nil nil)
(defsysfun 'CAAADR "Lcaaadr" nil nil nil nil)
(defsysfun 'CAADAR "Lcaadar" nil nil nil nil)
(defsysfun 'CAADDR "Lcaaddr" nil nil nil nil)
(defsysfun 'CADAAR "Lcadaar" nil nil nil nil)
(defsysfun 'CADADR "Lcadadr" nil nil nil nil)
(defsysfun 'CADDAR "Lcaddar" nil nil nil nil)
(defsysfun 'CADDDR "Lcadddr" nil nil nil nil)
(defsysfun 'CDAAAR "Lcdaaar" nil nil nil nil)
(defsysfun 'CDAADR "Lcdaadr" nil nil nil nil)
(defsysfun 'CDADAR "Lcdadar" nil nil nil nil)
(defsysfun 'CDADDR "Lcdaddr" nil nil nil nil)
(defsysfun 'CDDAAR "Lcddaar" nil nil nil nil)
(defsysfun 'CDDADR "Lcddadr" nil nil nil nil)
(defsysfun 'CDDDAR "Lcdddar" nil nil nil nil)
(defsysfun 'CDDDDR "Lcddddr" nil nil nil nil)
(defsysfun 'CONS "Lcons" nil nil nil nil)
(defsysfun 'TREE-EQUAL "Ltree_equal" nil nil nil t)
(defsysfun 'ENDP "Lendp" nil nil nil t)
(defsysfun 'LIST-LENGTH "Llist_length" nil nil nil nil)
(defsysfun 'NTH "Lnth" '(fixnum t) nil nil nil)
(defsysfun 'FIRST "Lcar" nil nil nil nil)
(defsysfun 'REST "Lcdr" nil nil nil nil)
(defsysfun 'NTHCDR "Lnthcdr" '(fixnum t) nil nil nil)
(defsysfun 'LAST "Llast" nil nil nil nil)
(defsysfun 'LIST "Llist" nil nil nil nil)
(defsysfun 'LIST* "LlistA" nil nil nil nil)
(defsysfun 'MAKE-LIST "Lmake_list" '(fixnum) nil nil nil)
(defsysfun 'APPEND "Lappend" nil nil nil nil)
(defsysfun 'COPY-LIST "Lcopy_list" nil nil nil nil)
(defsysfun 'COPY-ALIST "Lcopy_alist" nil nil nil nil)
(defsysfun 'COPY-TREE "Lcopy_tree" nil nil nil nil)
(defsysfun 'REVAPPEND "Lrevappend" nil nil nil nil)
(defsysfun 'NCONC "Lnconc" nil nil nil nil)
(defsysfun 'NRECONC "Lreconc" nil nil nil nil)
(defsysfun 'BUTLAST "Lbutlast" nil nil nil nil)
(defsysfun 'NBUTLAST "Lnbutlast" nil nil nil nil)
(defsysfun 'LDIFF "Lldiff" nil nil nil nil)
(defsysfun 'RPLACA "Lrplaca" '(cons) nil nil nil)
(defsysfun 'RPLACD "Lrplacd" '(cons) nil nil nil)
(defsysfun 'SUBST "Lsubst" nil nil nil nil)
(defsysfun 'SUBST-IF "Lsubst_if" nil nil nil nil)
(defsysfun 'SUBST-IF-NOT "Lsubst_if_not" nil nil nil nil)
(defsysfun 'NSUBST "Lnsubst" nil nil nil nil)
(defsysfun 'NSUBST-IF "Lnsubst_if" nil nil nil nil)
(defsysfun 'NSUBST-IF-NOT "Lnsubst_if_not" nil nil nil nil)
(defsysfun 'SUBLIS "Lsublis" nil nil nil nil)
(defsysfun 'NSUBLIS "Lnsublis" nil nil nil nil)
(defsysfun 'MEMBER "Lmember" nil nil nil nil)
(defsysfun 'MEMBER-IF "Lmember_if" nil nil nil nil)
(defsysfun 'MEMBER-IF-NOT "Lmember_if_not" nil nil nil nil)
(defsysfun 'TAILP "Ltailp" nil nil nil t)
(defsysfun 'ADJOIN "Ladjoin" nil nil nil nil)
(defsysfun 'ACONS "Lacons" nil nil nil nil)
(defsysfun 'PAIRLIS "Lpairlis" nil nil nil nil)
(defsysfun 'ASSOC "Lassoc" nil nil nil nil)
(defsysfun 'ASSOC-IF "Lassoc_if" nil nil nil nil)
(defsysfun 'ASSOC-IF-NOT "Lassoc_if_not" nil nil nil nil)
(defsysfun 'RASSOC "Lrassoc" nil nil nil nil)
(defsysfun 'RASSOC-IF "Lrassoc_if" nil nil nil nil)
(defsysfun 'RASSOC-IF-NOT "Lrassoc_if_not" nil nil nil nil)
(defsysfun 'MACROEXPAND "Lmacroexpand" nil nil nil nil)
(defsysfun 'MACROEXPAND-1 "Lmacroexpand_1" nil nil nil nil)
(defsysfun 'BY "Lby" nil nil nil nil)
(defsysfun 'BYE "Lby" nil nil nil nil)
(defsysfun 'IDENTITY "Lidentity" nil nil nil nil)
(defsysfun 'SI:RESET-STACK-LIMITS "siLreset_stack_limits" nil nil nil nil)
(defsysfun 'SI:INIT-SYSTEM "siLinit_system" nil nil nil nil)
(defsysfun 'MAPCAR "Lmapcar" nil nil nil nil)
(defsysfun 'MAPLIST "Lmaplist" nil nil nil nil)
(defsysfun 'MAPC "Lmapc" nil nil nil nil)
(defsysfun 'MAPL "Lmapl" nil nil nil nil)
(defsysfun 'MAPCAN "Lmapcan" nil nil nil nil)
(defsysfun 'MAPCON "Lmapcon" nil nil nil nil)
(defsysfun 'VALUES "Lvalues" nil nil nil nil)
(defsysfun 'VALUES-LIST "Lvalues_list" nil nil nil nil)
(defsysfun '+ "Lplus" nil nil nil nil)
(defsysfun '- "Lminus" nil nil nil nil)
(defsysfun '* "Ltimes" nil nil nil nil)
(defsysfun '/ "Ldivide" nil nil nil nil)
(defsysfun '1+ "Lone_plus" nil nil nil nil)
(defsysfun '1- "Lone_minus" nil nil nil nil)
(defsysfun 'CONJUGATE "Lconjugate" nil nil nil nil)
(defsysfun 'GCD "Lgcd" nil nil nil nil)
(defsysfun 'LCM "Llcm" nil nil nil nil)
(defsysfun 'FLOAT "Lfloat" nil nil nil nil)
(defsysfun 'NUMERATOR "Lnumerator" nil nil nil nil)
(defsysfun 'DENOMINATOR "Ldenominator" nil nil nil nil)
(defsysfun 'FLOOR "Lfloor" nil nil nil nil)
(defsysfun 'CEILING "Lceiling" nil nil nil nil)
(defsysfun 'TRUNCATE "Ltruncate" nil nil nil nil)
(defsysfun 'ROUND "Lround" nil nil nil nil)
(defsysfun 'MOD "Lmod" nil nil nil nil)
(defsysfun 'REM "Lrem" nil nil nil nil)
(defsysfun 'DECODE-FLOAT "Ldecode_float" nil nil nil nil)
(defsysfun 'SCALE-FLOAT "Lscale_float" nil nil nil nil)
(defsysfun 'FLOAT-RADIX "Lfloat_radix" nil nil nil nil)
(defsysfun 'FLOAT-SIGN "Lfloat_sign" nil nil nil nil)
(defsysfun 'FLOAT-DIGITS "Lfloat_digits" nil nil nil nil)
(defsysfun 'FLOAT-PRECISION "Lfloat_precision" nil nil nil nil)
(defsysfun 'INTEGER-DECODE-FLOAT "Linteger_decode_float" nil nil nil nil)
(defsysfun 'COMPLEX "Lcomplex" nil nil nil nil)
(defsysfun 'REALPART "Lrealpart" nil nil nil nil)
(defsysfun 'IMAGPART "Limagpart" nil nil nil nil)
(defsysfun '= "Lall_the_same" nil nil nil t)
(defsysfun '/= "Lall_different" nil nil nil t)
(defsysfun '< "Lmonotonically_increasing" nil nil nil t)
(defsysfun '> "Lmonotonically_decreasing" nil nil nil t)
(defsysfun '<= "Lmonotonically_nondecreasing" nil nil nil t)
(defsysfun '>= "Lmonotonically_nonincreasing" nil nil nil t)
(defsysfun 'MAX "Lmax" nil nil nil nil)
(defsysfun 'MIN "Lmin" nil nil nil nil)
(defsysfun 'LOGIOR "Llogior" nil nil nil nil)
(defsysfun 'LOGXOR "Llogxor" nil nil nil nil)
(defsysfun 'LOGAND "Llogand" nil nil nil nil)
(defsysfun 'LOGEQV "Llogeqv" nil nil nil nil)
(defsysfun 'BOOLE "Lboole" nil nil nil nil)
(defsysfun 'LOGBITP "Llogbitp" nil nil nil t)
(defsysfun 'ASH "Lash" nil nil nil nil)
(defsysfun 'LOGCOUNT "Llogcount" nil nil nil nil)
(defsysfun 'INTEGER-LENGTH "Linteger_length" nil 'fixnum nil nil)
(defsysfun 'ZEROP "Lzerop" nil nil nil t)
(defsysfun 'PLUSP "Lplusp" nil nil nil t)
(defsysfun 'MINUSP "Lminusp" nil nil nil t)
(defsysfun 'ODDP "Loddp" nil nil nil t)
(defsysfun 'EVENP "Levenp" nil nil nil t)
(defsysfun 'RANDOM "Lrandom" nil nil nil nil)
(defsysfun 'MAKE-RANDOM-STATE "Lmake_random_state" nil nil nil nil)
(defsysfun 'RANDOM-STATE-P "Lrandom_state_p" nil nil nil t)
(defsysfun 'EXP "Lexp" nil nil nil nil)
(defsysfun 'EXPT "Lexpt" nil nil nil nil)
(defsysfun 'LOG "Llog" nil nil nil nil)
(defsysfun 'SQRT "Lsqrt" nil nil nil nil)
(defsysfun 'SIN "Lsin" nil nil nil nil)
(defsysfun 'COS "Lcos" nil nil nil nil)
(defsysfun 'TAN "Ltan" nil nil nil nil)
(defsysfun 'ATAN "Latan" nil nil nil nil)
(defsysfun 'MAKE-PACKAGE "Lmake_package" nil nil nil nil)
(defsysfun 'IN-PACKAGE "Lin_package" nil nil nil nil)
(defsysfun 'FIND-PACKAGE "Lfind_package" nil nil nil nil)
(defsysfun 'PACKAGE-NAME "Lpackage_name" nil nil nil nil)
(defsysfun 'PACKAGE-NICKNAMES "Lpackage_nicknames" nil nil nil nil)
(defsysfun 'RENAME-PACKAGE "Lrename_package" nil nil nil nil)
(defsysfun 'PACKAGE-USE-LIST "Lpackage_use_list" nil nil nil nil)
(defsysfun 'PACKAGE-USED-BY-LIST "Lpackage_used_by_list" nil nil nil nil)
(defsysfun 'LIST-ALL-PACKAGES "Llist_all_packages" nil nil nil nil)
(defsysfun 'INTERN "Lintern" '(string t) 'symbol nil nil)
(defsysfun 'FIND-SYMBOL "Lfind_symbol" '(string t) 'symbol nil nil)
(defsysfun 'UNINTERN "Lunintern" '(symbol t) nil nil nil)
(defsysfun 'EXPORT "Lexport" nil nil nil nil)
(defsysfun 'UNEXPORT "Lunexport" nil nil nil nil)
(defsysfun 'IMPORT "Limport" nil nil nil nil)
(defsysfun 'SHADOWING-IMPORT "Lshadowing_import" nil nil nil nil)
(defsysfun 'SHADOW "Lshadow" nil nil nil nil)
(defsysfun 'USE-PACKAGE "Luse_package" nil nil nil nil)
(defsysfun 'UNUSE-PACKAGE "Lunuse_package" nil nil nil nil)
(defsysfun 'SI:PACKAGE-INTERNAL "siLpackage_internal" nil nil nil nil)
(defsysfun 'SI:PACKAGE-EXTERNAL "siLpackage_external" nil nil nil nil)
(defsysfun 'PATHNAME "Lpathname" nil nil nil nil)
(defsysfun 'PARSE-NAMESTRING "Lparse_namestring" nil nil nil nil)
(defsysfun 'MERGE-PATHNAMES "Lmerge_pathnames" nil nil nil nil)
(defsysfun 'MAKE-PATHNAME "Lmake_pathname" nil nil nil nil)
(defsysfun 'PATHNAMEP "Lpathnamep" nil nil nil t)
(defsysfun 'PATHNAME-HOST "Lpathname_host" nil nil nil nil)
(defsysfun 'PATHNAME-DEVICE "Lpathname_device" nil nil nil nil)
(defsysfun 'PATHNAME-DIRECTORY "Lpathname_directory" nil nil nil nil)
(defsysfun 'PATHNAME-NAME "Lpathname_name" nil nil nil nil)
(defsysfun 'PATHNAME-TYPE "Lpathname_type" nil nil nil nil)
(defsysfun 'PATHNAME-VERSION "Lpathname_version" nil nil nil nil)
(defsysfun 'NAMESTRING "Lnamestring" nil 'string nil nil)
(defsysfun 'FILE-NAMESTRING "Lfile_namestring" nil 'string nil nil)
(defsysfun 'DIRECTORY-NAMESTRING "Ldirectory_namestring" nil 'string nil nil)
(defsysfun 'HOST-NAMESTRING "Lhost_namestring" nil 'string nil nil)
(defsysfun 'ENOUGH-NAMESTRING "Lenough_namestring" nil 'string nil nil)
(defsysfun 'NULL "Lnull" nil nil nil t)
(defsysfun 'SYMBOLP "Lsymbolp" nil nil nil t)
(defsysfun 'ATOM "Latom" nil nil nil t)
(defsysfun 'CONSP "Lconsp" nil nil nil t)
(defsysfun 'LISTP "Llistp" nil nil nil t)
(defsysfun 'NUMBERP "Lnumberp" nil nil nil t)
(defsysfun 'INTEGERP "Lintegerp" nil nil nil t)
(defsysfun 'FLOATP "Lfloatp" nil nil nil t)
(defsysfun 'COMPLEXP "Lcomplexp" nil nil nil t)
(defsysfun 'CHARACTERP "Lcharacterp" nil nil nil t)
(defsysfun 'STRINGP "Lstringp" nil nil nil t)
(defsysfun 'BIT-VECTOR-P "Lbit_vector_p" nil nil nil t)
(defsysfun 'VECTORP "Lvectorp" nil nil nil t)
(defsysfun 'SIMPLE-STRING-P "Lsimple_string_p" nil nil nil t)
(defsysfun 'SIMPLE-BIT-VECTOR-P "Lsimple_bit_vector_p" nil nil nil t)
(defsysfun 'SIMPLE-VECTOR-P "Lsimple_vector_p" nil nil nil t)
(defsysfun 'ARRAYP "Larrayp" nil nil nil t)
(defsysfun 'PACKAGEP "Lpackagep" nil nil nil t)
(defsysfun 'FUNCTIONP "Lfunctionp" nil nil nil t)
(defsysfun 'COMPILED-FUNCTION-P "Lcompiled_function_p" nil nil nil t)
(defsysfun 'COMMONP "Lcommonp" nil nil nil t)
(defsysfun 'EQ "Leq" nil nil nil t)
(defsysfun 'EQL "Leql" nil nil nil t)
(defsysfun 'EQUAL "Lequal" nil nil nil t)
(defsysfun 'EQUALP "Lequalp" nil nil nil t)
(defsysfun 'NOT "Lnull" nil nil nil t)
(defsysfun 'WRITE "Lwrite" nil nil nil nil)
(defsysfun 'PRIN1 "Lprin1" nil nil nil nil)
(defsysfun 'PRINT "Lprint" nil nil nil nil)
(defsysfun 'PPRINT "Lpprint" nil nil nil nil)
(defsysfun 'PRINC "Lprinc" nil nil nil nil)
(defsysfun 'WRITE-CHAR "Lwrite_char" nil nil nil nil)
(defsysfun 'WRITE-STRING "Lwrite_string" nil nil nil nil)
(defsysfun 'WRITE-LINE "Lwrite_line" nil nil nil nil)
(defsysfun 'TERPRI "Lterpri" nil nil nil nil)
(defsysfun 'FRESH-LINE "Lfresh_line" nil nil nil nil)
(defsysfun 'FINISH-OUTPUT "Lfinish_output" nil nil nil nil)
(defsysfun 'FORCE-OUTPUT "Lforce_output" nil nil nil nil)
(defsysfun 'CLEAR-OUTPUT "Lclear_output" nil nil nil nil)
(defsysfun 'WRITE-BYTE "Lwrite_byte" '(fixnum stream) nil nil nil)
(defsysfun 'READ "Lread" nil nil nil nil)
(defsysfun 'READ-DELIMITED-LIST "Lread_delimited_list" nil nil nil nil)
(defsysfun 'READ-LINE "Lread_line" nil nil nil nil)
(defsysfun 'READ-CHAR "Lread_char" nil nil nil nil)
(defsysfun 'UNREAD-CHAR "Lunread_char" nil nil nil nil)
(defsysfun 'PEEK-CHAR "Lpeek_char" nil nil nil nil)
(defsysfun 'LISTEN "Llisten" nil nil nil nil)
(defsysfun 'READ-CHAR-NO-HANG "Lread_char_no_hang" nil nil nil nil)
(defsysfun 'CLEAR-INPUT "Lclear_input" nil nil nil nil)
(defsysfun 'PARSE-INTEGER "Lparse_integer" nil nil nil nil)
(defsysfun 'READ-BYTE "Lread_byte" nil nil nil nil)
(defsysfun 'COPY-READTABLE "Lcopy_readtable" nil nil nil nil)
(defsysfun 'READTABLEP "Lreadtablep" nil nil nil t)
(defsysfun 'SET-SYNTAX-FROM-CHAR "Lset_syntax_from_char" nil nil nil nil)
(defsysfun 'SET-MACRO-CHARACTER "Lset_macro_character" nil nil nil nil)
(defsysfun 'GET-MACRO-CHARACTER "Lget_macro_character" nil nil nil nil)
(defsysfun 'SI:STRING-TO-OBJECT "siLstring_to_object" nil nil nil nil)
(defsysfun 'SYMBOL-FUNCTION "Lsymbol_function" '(symbol) nil nil nil)
(defsysfun 'FBOUNDP "Lfboundp" '(symbol) nil nil t)
(defsysfun 'SYMBOL-VALUE "Lsymbol_value" '(symbol) nil nil nil)
(defsysfun 'BOUNDP "Lboundp" '(symbol) nil nil t)
(defsysfun 'MACRO-FUNCTION "Lmacro_function" '(symbol) nil nil nil)
(defsysfun 'SPECIAL-FORM-P "Lspecial_form_p" '(symbol) nil nil t)
(defsysfun 'SAVE "Lsave" nil nil nil nil)
(defsysfun 'ELT "Lelt" '(sequence fixnum) nil nil nil)
(defsysfun 'SI:ELT-SET "siLelt_set" '(sequence fixnum t) nil nil nil)
(defsysfun 'SUBSEQ "Lsubseq" '(sequence fixnum fixnum) 'sequence nil nil)
(defsysfun 'COPY-SEQ "Lcopy_seq" '(sequence) 'sequence nil nil)
(defsysfun 'LENGTH "Llength" '(sequence) 'fixnum t nil)
(defsysfun 'REVERSE "Lreverse" '(sequence) 'sequence nil nil)
(defsysfun 'NREVERSE "Lnreverse" '(sequence) 'sequence nil nil)
(defsysfun 'CHAR "Lchar" '(string fixnum) 'character nil nil)
(defsysfun 'SI:CHAR-SET "siLchar_set" '(string fixnum character) 'character nil nil)
(defsysfun 'STRING= "Lstring_eq" '(string string) nil nil t)
(defsysfun 'STRING-EQUAL "Lstring_equal" '(string string) nil nil t)
(defsysfun 'STRING< "Lstring_l" '(string string) nil nil t)
(defsysfun 'STRING> "Lstring_g" '(string string) nil nil t)
(defsysfun 'STRING<= "Lstring_le" '(string string) nil nil t)
(defsysfun 'STRING>= "Lstring_ge" '(string string) nil nil t)
(defsysfun 'STRING/= "Lstring_neq" '(string string) nil nil t)
(defsysfun 'STRING-LESSP "Lstring_lessp" '(string string) nil nil t)
(defsysfun 'STRING-GREATERP "Lstring_greaterp" '(string string) nil nil t)
(defsysfun 'STRING-NOT-LESSP "Lstring_not_lessp" '(string string) nil nil t)
(defsysfun 'STRING-NOT-GREATERP "Lstring_not_greaterp" '(string string) nil nil t)
(defsysfun 'STRING-NOT-EQUAL "Lstring_not_equal" '(string string) nil nil t)
(defsysfun 'MAKE-STRING "Lmake_string" '(fixnum) 'string nil nil)
(defsysfun 'STRING-TRIM "Lstring_trim" '(t string) 'string nil nil)
(defsysfun 'STRING-LEFT-TRIM "Lstring_left_trim" '(t string) 'string nil nil)
(defsysfun 'STRING-RIGHT-TRIM "Lstring_right_trim" '(t string) 'string nil nil)
(defsysfun 'STRING-UPCASE "Lstring_upcase" '(string) 'string nil nil)
(defsysfun 'STRING-DOWNCASE "Lstring_downcase" '(string) 'string nil nil)
(defsysfun 'STRING-CAPITALIZE "Lstring_capitalize" '(string) 'string nil nil)
(defsysfun 'NSTRING-UPCASE "Lnstring_upcase" '(string) 'string nil nil)
(defsysfun 'NSTRING-DOWNCASE "Lnstring_downcase" '(string) 'string nil nil)
(defsysfun 'NSTRING-CAPITALIZE "Lnstring_capitalize" '(string) 'string nil nil)
(defsysfun 'STRING "Lstring" nil 'string nil nil)
(defsysfun 'SI:MAKE-STRUCTURE "siLmake_structure" nil nil nil nil)
(defsysfun 'SI:STRUCTURE-NAME "siLstructure_name" nil 'symbol nil nil)
(defsysfun 'SI:STRUCTURE-REF "siLstructure_ref" '(t t fixnum) nil nil nil)
(defsysfun 'SI:STRUCTURE-SET "siLstructure_set" '(t t fixnum t) nil nil nil)
(defsysfun 'SI:STRUCTUREP "siLstructurep" nil nil nil t)
(defsysfun 'GET "Lget" '(symbol t t) nil nil nil)
(defsysfun 'REMPROP "Lremprop" '(symbol t) nil nil nil)
(defsysfun 'SYMBOL-PLIST "Lsymbol_plist" '(symbol) nil nil nil)
(defsysfun 'GETF "Lgetf" nil nil nil nil)
(defsysfun 'GET-PROPERTIES "Lget_properties" nil nil nil nil)
(defsysfun 'SYMBOL-NAME "Lsymbol_name" '(symbol) 'string nil nil)
(defsysfun 'MAKE-SYMBOL "Lmake_symbol" '(string) 'symbol nil nil)
(defsysfun 'COPY-SYMBOL "Lcopy_symbol" '(symbol) 'symbol nil nil)
(defsysfun 'GENSYM "Lgensym" nil 'symbol nil nil)
(defsysfun 'GENTEMP "Lgentemp" nil 'symbol nil nil)
(defsysfun 'SYMBOL-PACKAGE "Lsymbol_package" '(symbol) nil nil nil)
(defsysfun 'KEYWORDP "Lkeywordp" nil nil nil t)
(defsysfun 'SI:PUT-F "siLput_f" nil nil nil nil)
(defsysfun 'SI:REM-F "siLrem_f" nil nil nil nil)
(defsysfun 'SI:SET-SYMBOL-PLIST "siLset_symbol_plist" '(symbol t) nil nil nil)
(defsysfun 'SI:PUTPROP "siLputprop" '(symbol t t) nil nil nil)
(defsysfun 'SLEEP "Lsleep" '(fixnum) nil nil nil)
(defsysfun 'GET-INTERNAL-RUN-TIME "Lget_internal_run_time" nil nil nil nil)
(defsysfun 'GET-INTERNAL-REAL-TIME "Lget_internal_real_time" nil nil nil nil)
(defsysfun 'TYPE-OF "Ltype_of" nil nil nil nil)
