;;; CMPVS  Value stack manager.
;;;
;; (c) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
;; Copying of this file is authorized to users who have executed the true and
;; proper "License Agreement for Kyoto Common LISP" with SIGLISP.

(in-package 'compiler)

(si:putprop 'vs 'set-vs 'set-loc)
(si:putprop 'vs 'wt-vs 'wt-loc)
(si:putprop 'vs* 'wt-vs* 'wt-loc)
(si:putprop 'ccb-vs 'wt-ccb-vs 'wt-loc)

(defvar *vs* 0)
(defvar *max-vs* 0)
(defvar *clink* nil)
(defvar *ccb-vs* 0)
(defvar *initial-ccb-vs*)
(defvar *level* 0)

;;; *vs* holds the offset of the current vs-top.
;;; *max-vs* holds the maximum offset so far.
;;; *clink* holds NIL or the vs-address of the last ccb object.
;;; *ccb-vs* holds the top of the level 0 vs.
;;; *initial-ccb-vs* holds the value of *ccb-vs* when Pass 2 began to process
;;; a local (possibly closure) function.
;;; *level* holds the current function level.  *level* is 0 for a top-level
;;; function.

(defun vs-push ()
  (prog1 (cons *level* *vs*)
         (incf *vs*)
         (setq *max-vs* (max *vs* *max-vs*))))

(defun set-vs (loc vs)
  (unless (and (consp loc)
               (eq (car loc) 'vs)
               (equal (cadr loc) vs))
          (wt-nl)
          (wt-vs vs)
          (wt "= " loc ";")))
          
(defun wt-vs (vs)
  (if (= (car vs) *level*)
      (wt "base[" (cdr vs) "]")
      (wt "base" (car vs) "[" (cdr vs) "]")))

(defun wt-vs* (vs)
  (if (= (car vs) *level*)
      (wt "(base[" (cdr vs) "]->c.c_car)")
      (wt "(base" (car vs) "[" (cdr vs) "]->c.c_car)")))

(defun wt-ccb-vs (ccb-vs)
  (wt "(base0[" (- *initial-ccb-vs* ccb-vs) "]->c.c_car)"))

(defun clink (vs) (setq *clink* vs))

(defun wt-clink (&optional (clink *clink*))
  (if (null clink) (wt "Cnil") (wt-vs clink)))

(defun ccb-vs-push () (incf *ccb-vs*))




