/*
(C) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
*/

/*
	time.c
	DG-SPECIFIC
*/

#include <include.h>
#include <sysid.h>

object siVdefault_time_zone;

Lget_decoded_time()
{
	int sec, min, h, d, m, y, dow, work;

	check_arg(0);

	sys($GTOD, &sec,&min,&h);
	sys($GDAY, &d, &m, &y);
	work = d;
	sys($FDAY, &work, &m, &y);
	dow = (work + 6) % 7 ;
	vs_push(make_fixnum(sec));
	vs_push(make_fixnum(min));
	vs_push(make_fixnum(h));
	vs_push(make_fixnum(d));
	vs_push(make_fixnum(m));
	vs_push(make_fixnum(y + 1900));
	vs_push(make_fixnum(dow));
	vs_push(Cnil);
	vs_push(symbol_value(siVdefault_time_zone));
}

Lsleep()
{
	object z;
	
	check_arg(1);
	check_type_or_rational_float(&vs_base[0]);
	if (number_minusp(vs_base[0]) == TRUE)
		FEerror("~S is not a non-negative number.", 1, vs_base[0]);
	Lround();
	z = vs_base[0];
	if (type_of(z) == t_fixnum)
		sleep(fix(z));
	else
		for(;;)
			sleep(1000);
	vs_top = vs_base;
	vs_push(Cnil);
}

object
internal_time(flg)
int flg;
{
	int ac0, ac1, ac2;
	int pack[4];

	ac0 = -1;
	ac2 = (int)pack;
	sys($RUNTM, &ac0, &ac1, &ac2);
	if (flg)
		return(make_fixnum(pack[1]));
	else
		return(make_fixnum(pack[0] * 1000));
}

Lget_internal_run_time()
{
	object z;

	check_arg(0);
	z = internal_time(1);
	vs_push(z);
}

Lget_internal_real_time()
{
	object z;

	check_arg(0);
	z = internal_time(0);
	vs_push(z);
}

init_time()
{
	siVdefault_time_zone
	= make_si_special("*DEFAULT-TIME-ZONE*", make_fixnum(TIME_ZONE));
	make_constant("INTERNAL-TIME-UNITS-PER-SECOND", make_fixnum(1000));
	make_function("GET-DECODED-TIME", Lget_decoded_time);
	make_function("SLEEP", Lsleep);
	make_function("GET-INTERNAL-RUN-TIME", Lget_internal_run_time);
	make_function("GET-INTERNAL-REAL-TIME", Lget_internal_real_time);
}
