/*
OS/2 - emx version of the time module.
Sentot Kromodimoeljo, October 1993.
*/

/*
(c) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
Copying of this file is authorized to users who have executed the true and
proper "License Agreement for Kyoto Common LISP" with SIGLISP.
*/

#include "include.h"
#include <sys/types.h>
#include <sys/time.h>
struct timeval beginning;

/*
  Return the time between now and beginning, in milliseconds.
*/
  
int
get_interval ()
{
  struct timeval now;

  gettimeofday (&now, 0);

  return (((now.tv_sec - beginning.tv_sec) * 1000) +
	  ((now.tv_usec - beginning.tv_usec) / 1000));
}

runtime()
{
	return (get_interval ());
}

object
unix_time_to_universal_time(i)
int i;
{
	object x;
	vs_mark;

	vs_push(make_fixnum(24*60*60));
	vs_push(make_fixnum(70*365+17));
	x = number_times(vs_top[-1], vs_top[-2]);
	vs_push(x);
	vs_push(make_fixnum(i));
	x = number_plus(vs_top[-1], vs_top[-2]);
	vs_reset;
	return(x);
}

Lget_universal_time()
{
	check_arg(0);
	vs_push(unix_time_to_universal_time(time(0)));
}

Lsleep()
{
	object z;
	
	check_arg(1);
	check_type_or_rational_float(&vs_base[0]);
	if (number_minusp(vs_base[0]) == TRUE)
		FEerror("~S is not a non-negative number.", 1, vs_base[0]);
	Lround();
	z = vs_base[0];
	if (type_of(z) == t_fixnum)
		sleep(fix(z));
	else
		for(;;)
			sleep(1000);
	vs_top = vs_base;
	vs_push(Cnil);
}

Lget_internal_run_time()
{
	check_arg(0);
	vs_push(make_fixnum(get_interval()));
}

Lget_internal_real_time()
{
	check_arg(0);
	vs_push(make_fixnum(get_interval()));
}

init_unixtime()
{
	gettimeofday (&beginning, 0);
	make_si_special("*DEFAULT-TIME-ZONE*", make_fixnum(TIME_ZONE));
	make_constant("INTERNAL-TIME-UNITS-PER-SECOND", make_fixnum(1000));

	make_function("GET-UNIVERSAL-TIME", Lget_universal_time);
	make_function("SLEEP", Lsleep);
	make_function("GET-INTERNAL-RUN-TIME", Lget_internal_run_time);
	make_function("GET-INTERNAL-REAL-TIME", Lget_internal_real_time);
}
