/*
OS/2 - emx version of the image save.  It produces a core dump using
_core.  Must then use emxbind with raw_kcl as the a.out file.
Sentot Kromodimoeljo, October 1993.
*/

/*
(c) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
Copying of this file is authorized to users who have executed the true and
proper "License Agreement for Kyoto Common LISP" with SIGLISP.
*/

#include "include.h"

#include <sys/file.h>
#include <a_out.h>

filecpy(to, from, n)
FILE *to, *from;
register int n;
{
	char buffer[BUFSIZ];

	for (;;)
		if (n > BUFSIZ) {
			fread(buffer, BUFSIZ, 1, from);
			fwrite(buffer, BUFSIZ, 1, to);
			n -= BUFSIZ;
		} else if (n > 0) {
			fread(buffer, 1, n, from);
			fwrite(buffer, 1, n, to);
			break;
		} else
			break;
}

memory_save(original_file, save_file)
char *original_file, *save_file;
{
	FILE *original, *save;
	register int n;
	extern char stdin_buf[BUFSIZ], stdout_buf[BUFSIZ];

	stdin->buffer = NULL;
	fclose(stdin);
	original = fopen(original_file, "rb");

	if (stdin != original || fileno(original) != 0) {
		fprintf(stderr, "Can't open the original file.\n");
		exit(1);
	}
	setbuf(original, stdin_buf);
	stdout->buffer = NULL;
	fclose(stdout);
	unlink(save_file);
	n = open(save_file, O_CREAT|O_WRONLY|O_BINARY, 0777);

	if (n != 1 || (save = fdopen(n, "wb")) != stdout) {
		fprintf(stderr, "Can't open the save file.\n");
		exit(1);
	}
	_core(fileno(save));
	fclose(original);
	fclose(save);
}

Lsave()
{
	char filename[256];

	check_arg(1);
	check_type_or_pathname_string_symbol_stream(&vs_base[0]);
	coerce_to_filename(vs_base[0], filename);
	_cleanup();
	memory_save(kcl_self, filename);
	_exit(0);

	/*  no return  */
}

init_unixsave()
{
	make_function("SAVE", Lsave);
}
