/* fflush.c (emx+gcc) -- Copyright (c) 1990-1992 by Eberhard Mattes */

/*
Needed to modify fflush to not do anything if the buffer is NULL.
Sentot Kromodimoeljo, October 1993.
*/

#include <sys/emx.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <io.h>

int fflush (FILE *stream)
    {
    int result, n, ft;
    long pos;

    result = 0;
    if (stream->buffer != NULL) {
    if ((stream->flags & _IOWRT) && bbuf (stream))
        {
        n = stream->ptr - stream->buffer;
        if (n > 0 && write (fileno (stream), stream->buffer, n) <= 0)
            {
            stream->flags |= _IOERR;
            result = EOF;
            }
        }
    if ((stream->flags & _IOREAD) && bbuf (stream) &&
                 ioctl (fileno (stream), FGETHTYPE, &ft) >= 0 && ft == HT_FILE)
        {
        pos = ftell (stream);
        if (pos == -1L)
            result = EOF;
        else if (lseek (fileno (stream), pos, SEEK_SET) == -1L)
            result = EOF;
        }
    stream->ptr = stream->buffer;
    stream->rcount = 0;
    stream->wcount = 0;
    stream->flags &= ~_IOREREAD;    /* Undo ungetc */
  }
    return (result);
    }
