#ifdef djgpp
#  define DOS_CONIO
#endif
#ifdef os2
#  define DOS_CONIO
#endif

#ifdef DOS_CONIO
#  include <conio.h>
#  include <io.h>
#else
#  include <fcntl.h>
#  include <sys/ioctl.h>
#  include <stdio.h>
#  ifdef opsys_sysV
#    include <sys/termio.h>      /* sysV  */
#  else
#    include <sgtty.h>           /* bsd   */
#  endif
#endif


/* *************** XYplane_Key () *************** */

#ifdef DOS_CONIO

char XYplane_Key ()
{
   char c = getch();
   if (c == '\r') c = '\n';    /* Must convert carriage return */
   return c;
}
#else
#ifdef opsys_sysV

char XYplane_Key ()
{
    int sav,idummy;
    char x;
    struct termio savio, newio;
/* save current mode */
    ioctl(0,TCGETA,&savio);
    newio = savio;
/* set raw mode */
    newio.c_lflag &= ~(ECHO + ICANON + ISIG);
    newio.c_cc[VMIN] = '\001';
    ioctl(0,TCSETA,&newio);
/* save the file descriptor status flags */
    sav=fcntl(0,F_GETFL,0);
/* set the status flag for O_NDELAY = O_NONBLOCK */
    idummy=fcntl(0,F_SETFL,O_NDELAY);
/*
 * try to read from stdin ... if read returns -1 then there was no character
 * to be read in the buffer. If the read returns any other value then it is
 * the character read.
 */
    x = getchar();
/* set the flags to zero to cancel the O_NDELAY bit then set the flags back
   to the saved original values.  */
    idummy=fcntl(0,F_SETFL,0);
    idummy=fcntl(0,F_SETFL,sav);
/* return to canonical mode */
    ioctl(0,TCSETA,&savio);
    if ((x == savio.c_cc[VINTR]) && (savio.c_lflag & ISIG)) exit(1);

    if(x != -1) return x;
    return '\0';
}
#endif  /* SystemV version of Key */


#ifdef opsys_bsd

char XYplane_Key ()
{
    struct sgttyb savio, newio;
    struct tchars chrs;
    int x, sav,idummy;

/* save current mode */
    ioctl(0,TIOCGETP,&savio);
    ioctl(0,TIOCGETC,&chrs);
    newio = savio;
/* set into cbreak mode */
    newio.sg_flags = (newio.sg_flags & ~(ECHO + CBREAK)) | RAW ;
    ioctl(0,TIOCSETP,&newio);
/* save the file descriptor status flags */
    sav=fcntl(0,F_GETFL,0);
/* set the status flag for O_NONBLOCK */
    idummy=fcntl(0,F_SETFL,O_NONBLOCK);
/* try to read from stdin...if read returns -1 then there
   was no character to be read in the buffer. If the read returns
   any other value (0) then there was a character to be read.  */
    x = getchar();
/* set the flags to zero to cancel the O_NDELAY bit then set the flags back
   to the saved original values.  */
    idummy=fcntl(0,F_SETFL,0);
    idummy=fcntl(0,F_SETFL,sav);
/* now return to canonical mode */
    ioctl(0,TIOCSETP,&savio);
    if ((char)x == chrs.t_intrc) exit(1);
    if (x == EOF) x = 0;
    return (char)x;
}
# endif /* BSD version of Key */
#endif        /* DOS_CONIO */
