.\" $Header: gpmake.1,v 2.22 88/04/06 11:48:07 mee content6 $
.\" @(#) gpmake.1 1.4  @(#)gpmake.1	1.4  12/11/85  1   
.TH GPMAKE 1 "" "" HP-UX
.SH NAME
gpmake \- smart make utility for gardens point modula compiler 
.SH SYNOPSIS
.br
.B gpmake
[
.B \-options
]
.I basefile ...

.br
.B gpscript
[
.B \-options
]
.I basefile ...

.SH DESCRIPTION
.B gpmake
is a recompilation tool for
.B gpm\
\&.
It provides for recompilation of the minimum number of files necessary
to bring the program into a consistent state. It will check the time stamps
on source files to see if they are consistent with the time stamps on the
corresponding .o, .rfx, and .syx files. 
.B gpmake
only checks files in the current directory for consistency, and will 
only recompile files in this directory. The presence of required
files on the
paths $M2SYM and $M2LIB are checked, but such library files are assumed
to be consistent.

In the case of imported files, the system relies on the cryptographic
checksum on the symbol file to verify consistency. It follows that if 
a definition module has been recompiled, but has not been changed from a
previous compilation, all dependent modules will still be consistent.

.I basefile
must be the filename, with or without extension, of a program module.
.B gpmake
will complain if asked to compile and build a file which is not
the base file of a program. It will prompt for an alternative if 
either the file is not found, or is invalid.

The program provides for compilation and building operations.
In simple cases a program may be completely rebuilt after modification
by a single command. gpmake issues messages to standard output so 
the process of recompilation can be traced.

.B gpscript
performs the same analysis as gpmake, but produces as output a shell file
to perform a complete recompilation of all of the modules of the program 
which are in the current directory. This is particularly useful if 
different files of a program need to be compiled with different 
command line options. The command
.B gpscript foo.mod
would produce as output an script file
.B foo.mak
This file is executable for all users who have read permission on 
the original .mod file.

.SS Command line options
Command line options are simply passed to the compiler together with
each module which is recompiled.
Thus if different files require different options, it is necessary
to use 
.B gpscript
and manually edit the output script file.

In the case of the -V (superverbose) option, gpmake and gpscript will
output a summary of their string table usage, as well as passing the -V
to the compiler.

.SH CAVEATS AND BUGS
All these programs assume the standard conventions for the
formation of filenames from module names. Thus if the names have been
changed from the default, they will not be found by the automatic process.

