DEFINITION MODULE Tree;

IMPORT SYSTEM, IO;
(* line 23 "modula.cg" *)

FROM SYSTEM	IMPORT ADDRESS;
FROM StringMem	IMPORT tStringRef;
FROM Idents	IMPORT tIdent;
FROM Positions	IMPORT tPosition;
FROM Defs	IMPORT tObject, tObjects, tType, tTypes, tEnv,
		       tSelectors, tVoid, tCObjects, tStrings;
FROM Values	IMPORT tValue;
FROM UniqueIds	IMPORT tIdents;

TYPE
  yyEstra	= ADDRESS;		(* type used by ESTRA		*)


CONST
NoTree = NIL;

ROOT = 1;
CompUnits = 2;
CompUnits0 = 3;
CompUnit = 4;
DefMod = 5;
ProgMod = 6;
Import = 7;
Import0 = 8;
Import1 = 9;
From = 10;
Objects = 11;
ImpIds = 12;
ImpIds0 = 13;
ImpIds1 = 14;
Export = 15;
Export0 = 16;
Export1 = 17;
ExpIds = 18;
ExpIds0 = 19;
ExpIds1 = 20;
Decls = 21;
Decls0 = 22;
Decl = 23;
Var = 24;
Object = 25;
Const = 26;
TypeDecl = 27;
Proc = 28;
ProcHead = 29;
Module = 30;
Opaque = 31;
VarIds = 32;
VarIds0 = 33;
VarIds1 = 34;
Formals = 35;
Formals0 = 36;
Formals1 = 37;
ParIds = 38;
ParIds0 = 39;
ParIds1 = 40;
Type = 41;
Array = 42;
Record = 43;
SetType = 44;
Pointer = 45;
ProcType = 46;
SimpleType = 47;
Enumeration = 48;
Subrange = 49;
PrimaryType = 50;
Void = 51;
TypeId = 52;
TypeId0 = 53;
TypeId1 = 54;
Fields = 55;
Fields0 = 56;
Fields1 = 57;
RecordSect = 58;
VariantSect = 59;
FieldIds = 60;
FieldIds0 = 61;
FieldIds1 = 62;
TagField = 63;
TagField0 = 64;
TagField1 = 65;
Variants = 66;
Variants0 = 67;
Variant = 68;
FormalTypes = 69;
FormalTypes0 = 70;
FormalType = 71;
EnumIds = 72;
EnumIds0 = 73;
EnumIds1 = 74;
Expr = 75;
Binary = 76;
Unary = 77;
IntConst = 78;
RealConst = 79;
StringConst = 80;
CharConst = 81;
FuncCall = 82;
Set = 83;
BitSet = 84;
Designator = 85;
Qualid = 86;
Qualid0 = 87;
Qualid1 = 88;
Subscript = 89;
Deref = 90;
Select = 91;
Elems = 92;
Elems0 = 93;
Elems1 = 94;
Elem = 95;
ElemRange = 96;
Actuals = 97;
Actuals0 = 98;
Actual = 99;
Stmts = 100;
Stmts0 = 101;
Stmt = 102;
Assign = 103;
Call = 104;
If = 105;
Case = 106;
While = 107;
Repeat = 108;
Loop = 109;
For = 110;
With = 111;
Exit = 112;
Return1 = 113;
Return2 = 114;
Elsifs = 115;
Elsifs0 = 116;
Elsifs1 = 117;
Cases = 118;
Cases0 = 119;
Cases1 = 120;
Labels = 121;
Labels0 = 122;
Labels1 = 123;
Label = 124;
LabelRange = 125;

TYPE tTree = POINTER TO yyNode;
tProcTree = PROCEDURE (tTree);
(* line 37 "modula.cg" *)

CONST
  Definition		=  1;		(* compilation unit kind	*) 
  Foreign		=  2;
  Implementation	=  3;
  Program		=  4;

  NotEqual		=  1;		(* operators			*)
  Times			=  2;
  Plus			=  3;
  Minus			=  4;
  Divide		=  5;
  Less			=  6;
  LessEqual		=  7;
  Equal			=  8;
  Greater		=  9;
  GreaterEqual		= 10;
  And			= 11;
  Div			= 12;
  In			= 13;
  Mod			= 14;
  Not			= 15;
  Or			= 16;

  Decimal		=  1;		(* integer constant kind	*)
  Octal			=  2;
  Hexadecimal		=  3;





TYPE
yytNodeHead = RECORD yyKind, yyMark: SHORTCARD;  END;
yROOT = RECORD yyHead: yytNodeHead; CompUnits: tTree; END;
yCompUnits = RECORD yyHead: yytNodeHead; Objects1: tObjects; PosIn: SHORTCARD; END;
yCompUnits0 = RECORD yyHead: yytNodeHead; Objects1: tObjects; PosIn: SHORTCARD; END;
yCompUnit = RECORD yyHead: yytNodeHead; Objects1: tObjects; PosIn: SHORTCARD; Kind: SHORTCARD; Ident: tIdent; Pos: tPosition; Next: tTree; Object: tObject; END;
yDefMod = RECORD yyHead: yytNodeHead; Objects1: tObjects; PosIn: SHORTCARD; Kind: SHORTCARD; Ident: tIdent; Pos: tPosition; Next: tTree; Object: tObject; Import: tTree; Decls: tTree; END;
yProgMod = RECORD yyHead: yytNodeHead; Objects1: tObjects; PosIn: SHORTCARD; Kind: SHORTCARD; Ident: tIdent; Pos: tPosition; Next: tTree; Object: tObject; Import: tTree; Decls: tTree; Stmts: tTree; GlobalPtrs: tCObjects; Strings: tStrings; END;
yImport = RECORD yyHead: yytNodeHead; Objects2: tObjects; Env1: tEnv; END;
yImport0 = RECORD yyHead: yytNodeHead; Objects2: tObjects; Env1: tEnv; END;
yImport1 = RECORD yyHead: yytNodeHead; Objects2: tObjects; Env1: tEnv; Next: tTree; END;
yFrom = RECORD yyHead: yytNodeHead; Objects2: tObjects; Env1: tEnv; Next: tTree; Ident: tIdent; Pos: tPosition; ImpIds: tTree; END;
yObjects = RECORD yyHead: yytNodeHead; Objects2: tObjects; Env1: tEnv; Next: tTree; ImpIds: tTree; END;
yImpIds = RECORD yyHead: yytNodeHead; END;
yImpIds0 = RECORD yyHead: yytNodeHead; END;
yImpIds1 = RECORD yyHead: yytNodeHead; Ident: tIdent; Pos: tPosition; Next: tTree; END;
yExport = RECORD yyHead: yytNodeHead; Objects2: tObjects; IsQualified: BOOLEAN; END;
yExport0 = RECORD yyHead: yytNodeHead; Objects2: tObjects; IsQualified: BOOLEAN; END;
yExport1 = RECORD yyHead: yytNodeHead; Objects2: tObjects; IsQualified: BOOLEAN; Qualified: BOOLEAN; ExpIds: tTree; END;
yExpIds = RECORD yyHead: yytNodeHead; END;
yExpIds0 = RECORD yyHead: yytNodeHead; END;
yExpIds1 = RECORD yyHead: yytNodeHead; Ident: tIdent; Next: tTree; Object1: tObject; Object2: tObject; END;
yDecls = RECORD yyHead: yytNodeHead; Objects1: tObjects; Objects3: tObjects; Objects4In: tObjects; Objects4Out: tObjects; DefTypes: tObjects; DefObjects: tObjects; Env1: tEnv; Env2: tVoid; Env3: tEnv; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Level: SHORTCARD; END;
yDecls0 = RECORD yyHead: yytNodeHead; Objects1: tObjects; Objects3: tObjects; Objects4In: tObjects; Objects4Out: tObjects; DefTypes: tObjects; DefObjects: tObjects; Env1: tEnv; Env2: tVoid; Env3: tEnv; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Level: SHORTCARD; END;
yDecl = RECORD yyHead: yytNodeHead; Objects1: tObjects; Objects3: tObjects; Objects4In: tObjects; Objects4Out: tObjects; DefTypes: tObjects; DefObjects: tObjects; Env1: tEnv; Env2: tVoid; Env3: tEnv; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Level: SHORTCARD; Next: tTree; END;
yVar = RECORD yyHead: yytNodeHead; Objects1: tObjects; Objects3: tObjects; Objects4In: tObjects; Objects4Out: tObjects; DefTypes: tObjects; DefObjects: tObjects; Env1: tEnv; Env2: tVoid; Env3: tEnv; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Level: SHORTCARD; Next: tTree; VarIds: tTree; Type: tTree; IsGlobal: BOOLEAN; END;
yObject = RECORD yyHead: yytNodeHead; Objects1: tObjects; Objects3: tObjects; Objects4In: tObjects; Objects4Out: tObjects; DefTypes: tObjects; DefObjects: tObjects; Env1: tEnv; Env2: tVoid; Env3: tEnv; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Level: SHORTCARD; Next: tTree; Ident: tIdent; CIdent: tIdent; END;
yConst = RECORD yyHead: yytNodeHead; Objects1: tObjects; Objects3: tObjects; Objects4In: tObjects; Objects4Out: tObjects; DefTypes: tObjects; DefObjects: tObjects; Env1: tEnv; Env2: tVoid; Env3: tEnv; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Level: SHORTCARD; Next: tTree; Ident: tIdent; CIdent: tIdent; Expr: tTree; Object: tObject; END;
yTypeDecl = RECORD yyHead: yytNodeHead; Objects1: tObjects; Objects3: tObjects; Objects4In: tObjects; Objects4Out: tObjects; DefTypes: tObjects; DefObjects: tObjects; Env1: tEnv; Env2: tVoid; Env3: tEnv; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Level: SHORTCARD; Next: tTree; Ident: tIdent; CIdent: tIdent; Type: tTree; Pos: tPosition; Object: tObject; Type1: tType; END;
yProc = RECORD yyHead: yytNodeHead; Objects1: tObjects; Objects3: tObjects; Objects4In: tObjects; Objects4Out: tObjects; DefTypes: tObjects; DefObjects: tObjects; Env1: tEnv; Env2: tVoid; Env3: tEnv; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Level: SHORTCARD; Next: tTree; Ident: tIdent; CIdent: tIdent; Formals: tTree; ResultType: tTree; Decls: tTree; Stmts: tTree; Object: tObject; Type: tType; ValueOpens: tCObjects; VAROpens: tCObjects; LocalPtrs: tCObjects; Strings: tStrings; END;
yProcHead = RECORD yyHead: yytNodeHead; Objects1: tObjects; Objects3: tObjects; Objects4In: tObjects; Objects4Out: tObjects; DefTypes: tObjects; DefObjects: tObjects; Env1: tEnv; Env2: tVoid; Env3: tEnv; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Level: SHORTCARD; Next: tTree; Ident: tIdent; CIdent: tIdent; Formals: tTree; ResultType: tTree; Pos: tPosition; Object: tObject; END;
yModule = RECORD yyHead: yytNodeHead; Objects1: tObjects; Objects3: tObjects; Objects4In: tObjects; Objects4Out: tObjects; DefTypes: tObjects; DefObjects: tObjects; Env1: tEnv; Env2: tVoid; Env3: tEnv; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Level: SHORTCARD; Next: tTree; Ident: tIdent; CIdent: tIdent; Import: tTree; Export: tTree; Decls: tTree; Stmts: tTree; Object: tObject; Strings: tStrings; END;
yOpaque = RECORD yyHead: yytNodeHead; Objects1: tObjects; Objects3: tObjects; Objects4In: tObjects; Objects4Out: tObjects; DefTypes: tObjects; DefObjects: tObjects; Env1: tEnv; Env2: tVoid; Env3: tEnv; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Level: SHORTCARD; Next: tTree; Ident: tIdent; CIdent: tIdent; Object: tObject; Type1: tType; END;
yVarIds = RECORD yyHead: yytNodeHead; Objects3: tObjects; END;
yVarIds0 = RECORD yyHead: yytNodeHead; Objects3: tObjects; END;
yVarIds1 = RECORD yyHead: yytNodeHead; Objects3: tObjects; Ident: tIdent; Next: tTree; Object: tObject; CIdent: tIdent; END;
yFormals = RECORD yyHead: yytNodeHead; Objects3: tObjects; END;
yFormals0 = RECORD yyHead: yytNodeHead; Objects3: tObjects; END;
yFormals1 = RECORD yyHead: yytNodeHead; Objects3: tObjects; IsVAR: BOOLEAN; ParIds: tTree; Type: tTree; Next: tTree; END;
yParIds = RECORD yyHead: yytNodeHead; END;
yParIds0 = RECORD yyHead: yytNodeHead; END;
yParIds1 = RECORD yyHead: yytNodeHead; Ident: tIdent; Next: tTree; Object: tObject; CIdent: tIdent; END;
yType = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; END;
yArray = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; IsOpen: BOOLEAN; IndexType: tTree; ElemType: tTree; END;
yRecord = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Fields: tTree; END;
ySetType = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; BaseType: tTree; END;
yPointer = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; TargetType: tTree; TypePos: SHORTCARD; END;
yProcType = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; FormalTypes: tTree; ResultType: tTree; END;
ySimpleType = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; END;
yEnumeration = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; EnumIds: tTree; END;
ySubrange = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; BaseType: tTree; Lwb: tTree; Upb: tTree; Type3: tType; END;
yPrimaryType = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; END;
yVoid = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; END;
yTypeId = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Ident: tIdent; Pos: tPosition; Object: tObject; END;
yTypeId0 = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Ident: tIdent; Pos: tPosition; Object: tObject; END;
yTypeId1 = RECORD yyHead: yytNodeHead; Objects3: tObjects; Type1: tType; Type2: tType; Env1: tEnv; Env2: tVoid; Kind: SHORTCARD; Module: tIdent; CntIn: SHORTCARD; Ident: tIdent; Pos: tPosition; Object: tObject; TypeId: tTree; END;
yFields = RECORD yyHead: yytNodeHead; END;
yFields0 = RECORD yyHead: yytNodeHead; END;
yFields1 = RECORD yyHead: yytNodeHead; Next: tTree; END;
yRecordSect = RECORD yyHead: yytNodeHead; Next: tTree; FieldIds: tTree; Type: tTree; END;
yVariantSect = RECORD yyHead: yytNodeHead; Next: tTree; TagField: tTree; Variants: tTree; Else: tTree; UnionId: tIdent; ElseId: tIdent; END;
yFieldIds = RECORD yyHead: yytNodeHead; END;
yFieldIds0 = RECORD yyHead: yytNodeHead; END;
yFieldIds1 = RECORD yyHead: yytNodeHead; Ident: tIdent; Next: tTree; Object: tObject; CIdent: tIdent; END;
yTagField = RECORD yyHead: yytNodeHead; Type: tTree; Env1: tEnv; Env2: tVoid; END;
yTagField0 = RECORD yyHead: yytNodeHead; Type: tTree; Env1: tEnv; Env2: tVoid; END;
yTagField1 = RECORD yyHead: yytNodeHead; Type: tTree; Env1: tEnv; Env2: tVoid; Ident: tIdent; Object: tObject; CIdent: tIdent; END;
yVariants = RECORD yyHead: yytNodeHead; END;
yVariants0 = RECORD yyHead: yytNodeHead; END;
yVariant = RECORD yyHead: yytNodeHead; Labels: tTree; Variant: tTree; Next: tTree; StructId: tIdent; END;
yFormalTypes = RECORD yyHead: yytNodeHead; END;
yFormalTypes0 = RECORD yyHead: yytNodeHead; END;
yFormalType = RECORD yyHead: yytNodeHead; IsVAR: BOOLEAN; Type: tTree; Next: tTree; END;
yEnumIds = RECORD yyHead: yytNodeHead; Objects: tObjects; END;
yEnumIds0 = RECORD yyHead: yytNodeHead; Objects: tObjects; END;
yEnumIds1 = RECORD yyHead: yytNodeHead; Objects: tObjects; Ident: tIdent; Next: tTree; Object: tObject; CIdent: tIdent; END;
yExpr = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; END;
yBinary = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; Operator: SHORTCARD; Lop: tTree; Rop: tTree; COperator: SHORTCARD; END;
yUnary = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; Operator: SHORTCARD; Mop: tTree; COperator: SHORTCARD; END;
yIntConst = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; Kind: SHORTCARD; IntVal: CARDINAL; Pos: tPosition; END;
yRealConst = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; RealVal: tStringRef; END;
yStringConst = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; StringVal: tStringRef; END;
yCharConst = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; CharVal: CHAR; END;
yFuncCall = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; Designator: tTree; Actuals: tTree; END;
ySet = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; BaseType: tTree; Elems: tTree; END;
yBitSet = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; Elems: tTree; END;
yDesignator = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; Pos: tPosition; END;
yQualid = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; Pos: tPosition; Ident: tIdent; Object: tObject; IsGlobalPtr: BOOLEAN; END;
yQualid0 = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; Pos: tPosition; Ident: tIdent; Object: tObject; IsGlobalPtr: BOOLEAN; END;
yQualid1 = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; Pos: tPosition; Ident: tIdent; Object: tObject; IsGlobalPtr: BOOLEAN; Qualid: tTree; END;
ySubscript = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; Pos: tPosition; Designator: tTree; Index: tTree; END;
yDeref = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; Pos: tPosition; Designator: tTree; END;
ySelect = RECORD yyHead: yytNodeHead; Type: tType; IsCConst: BOOLEAN; Pos: tPosition; Designator: tTree; Field: tIdent; Object: tObject; END;
yElems = RECORD yyHead: yytNodeHead; END;
yElems0 = RECORD yyHead: yytNodeHead; END;
yElems1 = RECORD yyHead: yytNodeHead; Next: tTree; END;
yElem = RECORD yyHead: yytNodeHead; Next: tTree; Elem: tTree; END;
yElemRange = RECORD yyHead: yytNodeHead; Next: tTree; Lwb: tTree; Upb: tTree; END;
yActuals = RECORD yyHead: yytNodeHead; END;
yActuals0 = RECORD yyHead: yytNodeHead; END;
yActual = RECORD yyHead: yytNodeHead; Expr: tTree; Next: tTree; IsVAR: BOOLEAN; Formal: tType; String: tIdent; END;
yStmts = RECORD yyHead: yytNodeHead; END;
yStmts0 = RECORD yyHead: yytNodeHead; END;
yStmt = RECORD yyHead: yytNodeHead; Next: tTree; END;
yAssign = RECORD yyHead: yytNodeHead; Next: tTree; Designator: tTree; Expr: tTree; END;
yCall = RECORD yyHead: yytNodeHead; Next: tTree; Designator: tTree; Actuals: tTree; AllocOrDealloc: tObject; END;
yIf = RECORD yyHead: yytNodeHead; Next: tTree; Cond: tTree; Then: tTree; Elsifs: tTree; Else: tTree; END;
yCase = RECORD yyHead: yytNodeHead; Next: tTree; Expr: tTree; Cases: tTree; Else: tTree; Default: BOOLEAN; END;
yWhile = RECORD yyHead: yytNodeHead; Next: tTree; Cond: tTree; Stmts: tTree; END;
yRepeat = RECORD yyHead: yytNodeHead; Next: tTree; Stmts: tTree; Cond: tTree; END;
yLoop = RECORD yyHead: yytNodeHead; Next: tTree; Stmts: tTree; END;
yFor = RECORD yyHead: yytNodeHead; Next: tTree; Qualid: tTree; From: tTree; To: tTree; By: tTree; Stmts: tTree; ToVal: tValue; ByVal: tValue; END;
yWith = RECORD yyHead: yytNodeHead; Next: tTree; Designator: tTree; Stmts: tTree; END;
yExit = RECORD yyHead: yytNodeHead; Next: tTree; END;
yReturn1 = RECORD yyHead: yytNodeHead; Next: tTree; END;
yReturn2 = RECORD yyHead: yytNodeHead; Next: tTree; Result: tTree; OpenAccessOrCall: BOOLEAN; ResultType: tType; END;
yElsifs = RECORD yyHead: yytNodeHead; END;
yElsifs0 = RECORD yyHead: yytNodeHead; END;
yElsifs1 = RECORD yyHead: yytNodeHead; Cond: tTree; Stmts: tTree; Next: tTree; END;
yCases = RECORD yyHead: yytNodeHead; END;
yCases0 = RECORD yyHead: yytNodeHead; END;
yCases1 = RECORD yyHead: yytNodeHead; Labels: tTree; Stmts: tTree; Next: tTree; END;
yLabels = RECORD yyHead: yytNodeHead; END;
yLabels0 = RECORD yyHead: yytNodeHead; END;
yLabels1 = RECORD yyHead: yytNodeHead; Next: tTree; END;
yLabel = RECORD yyHead: yytNodeHead; Next: tTree; Label: tTree; LabelVal: tValue; END;
yLabelRange = RECORD yyHead: yytNodeHead; Next: tTree; Lwb: tTree; Upb: tTree; LwbVal: tValue; UpbVal: tValue; END;

yyNode = RECORD
CASE : SHORTCARD OF
| 0: Kind: SHORTCARD;
| 126: yyHead: yytNodeHead;
| ROOT: ROOT: yROOT;
| CompUnits: CompUnits: yCompUnits;
| CompUnits0: CompUnits0: yCompUnits0;
| CompUnit: CompUnit: yCompUnit;
| DefMod: DefMod: yDefMod;
| ProgMod: ProgMod: yProgMod;
| Import: Import: yImport;
| Import0: Import0: yImport0;
| Import1: Import1: yImport1;
| From: From: yFrom;
| Objects: Objects: yObjects;
| ImpIds: ImpIds: yImpIds;
| ImpIds0: ImpIds0: yImpIds0;
| ImpIds1: ImpIds1: yImpIds1;
| Export: Export: yExport;
| Export0: Export0: yExport0;
| Export1: Export1: yExport1;
| ExpIds: ExpIds: yExpIds;
| ExpIds0: ExpIds0: yExpIds0;
| ExpIds1: ExpIds1: yExpIds1;
| Decls: Decls: yDecls;
| Decls0: Decls0: yDecls0;
| Decl: Decl: yDecl;
| Var: Var: yVar;
| Object: Object: yObject;
| Const: Const: yConst;
| TypeDecl: TypeDecl: yTypeDecl;
| Proc: Proc: yProc;
| ProcHead: ProcHead: yProcHead;
| Module: Module: yModule;
| Opaque: Opaque: yOpaque;
| VarIds: VarIds: yVarIds;
| VarIds0: VarIds0: yVarIds0;
| VarIds1: VarIds1: yVarIds1;
| Formals: Formals: yFormals;
| Formals0: Formals0: yFormals0;
| Formals1: Formals1: yFormals1;
| ParIds: ParIds: yParIds;
| ParIds0: ParIds0: yParIds0;
| ParIds1: ParIds1: yParIds1;
| Type: Type: yType;
| Array: Array: yArray;
| Record: Record: yRecord;
| SetType: SetType: ySetType;
| Pointer: Pointer: yPointer;
| ProcType: ProcType: yProcType;
| SimpleType: SimpleType: ySimpleType;
| Enumeration: Enumeration: yEnumeration;
| Subrange: Subrange: ySubrange;
| PrimaryType: PrimaryType: yPrimaryType;
| Void: Void: yVoid;
| TypeId: TypeId: yTypeId;
| TypeId0: TypeId0: yTypeId0;
| TypeId1: TypeId1: yTypeId1;
| Fields: Fields: yFields;
| Fields0: Fields0: yFields0;
| Fields1: Fields1: yFields1;
| RecordSect: RecordSect: yRecordSect;
| VariantSect: VariantSect: yVariantSect;
| FieldIds: FieldIds: yFieldIds;
| FieldIds0: FieldIds0: yFieldIds0;
| FieldIds1: FieldIds1: yFieldIds1;
| TagField: TagField: yTagField;
| TagField0: TagField0: yTagField0;
| TagField1: TagField1: yTagField1;
| Variants: Variants: yVariants;
| Variants0: Variants0: yVariants0;
| Variant: Variant: yVariant;
| FormalTypes: FormalTypes: yFormalTypes;
| FormalTypes0: FormalTypes0: yFormalTypes0;
| FormalType: FormalType: yFormalType;
| EnumIds: EnumIds: yEnumIds;
| EnumIds0: EnumIds0: yEnumIds0;
| EnumIds1: EnumIds1: yEnumIds1;
| Expr: Expr: yExpr;
| Binary: Binary: yBinary;
| Unary: Unary: yUnary;
| IntConst: IntConst: yIntConst;
| RealConst: RealConst: yRealConst;
| StringConst: StringConst: yStringConst;
| CharConst: CharConst: yCharConst;
| FuncCall: FuncCall: yFuncCall;
| Set: Set: ySet;
| BitSet: BitSet: yBitSet;
| Designator: Designator: yDesignator;
| Qualid: Qualid: yQualid;
| Qualid0: Qualid0: yQualid0;
| Qualid1: Qualid1: yQualid1;
| Subscript: Subscript: ySubscript;
| Deref: Deref: yDeref;
| Select: Select: ySelect;
| Elems: Elems: yElems;
| Elems0: Elems0: yElems0;
| Elems1: Elems1: yElems1;
| Elem: Elem: yElem;
| ElemRange: ElemRange: yElemRange;
| Actuals: Actuals: yActuals;
| Actuals0: Actuals0: yActuals0;
| Actual: Actual: yActual;
| Stmts: Stmts: yStmts;
| Stmts0: Stmts0: yStmts0;
| Stmt: Stmt: yStmt;
| Assign: Assign: yAssign;
| Call: Call: yCall;
| If: If: yIf;
| Case: Case: yCase;
| While: While: yWhile;
| Repeat: Repeat: yRepeat;
| Loop: Loop: yLoop;
| For: For: yFor;
| With: With: yWith;
| Exit: Exit: yExit;
| Return1: Return1: yReturn1;
| Return2: Return2: yReturn2;
| Elsifs: Elsifs: yElsifs;
| Elsifs0: Elsifs0: yElsifs0;
| Elsifs1: Elsifs1: yElsifs1;
| Cases: Cases: yCases;
| Cases0: Cases0: yCases0;
| Cases1: Cases1: yCases1;
| Labels: Labels: yLabels;
| Labels0: Labels0: yLabels0;
| Labels1: Labels1: yLabels1;
| Label: Label: yLabel;
| LabelRange: LabelRange: yLabelRange;
END;
END;

VAR TreeRoot	: tTree;
VAR HeapUsed	: LONGCARD;
VAR yyPoolFreePtr, yyPoolMaxPtr	: SYSTEM.ADDRESS;
VAR yyNodeSize	: ARRAY [0..125] OF SHORTCARD;
VAR yyExit	: PROC;

PROCEDURE yyAlloc	(): tTree;
PROCEDURE MakeTree	(Kind: SHORTCARD): tTree;
PROCEDURE IsType	(Tree: tTree; Kind: SHORTCARD): BOOLEAN;

PROCEDURE mROOT (pCompUnits: tTree): tTree;
PROCEDURE mCompUnits (): tTree;
PROCEDURE mCompUnits0 (): tTree;
PROCEDURE mCompUnit (pKind: SHORTCARD; pIdent: tIdent; pPos: tPosition; pNext: tTree): tTree;
PROCEDURE mDefMod (pKind: SHORTCARD; pIdent: tIdent; pPos: tPosition; pNext: tTree; pImport: tTree; pDecls: tTree): tTree;
PROCEDURE mProgMod (pKind: SHORTCARD; pIdent: tIdent; pPos: tPosition; pNext: tTree; pImport: tTree; pDecls: tTree; pStmts: tTree): tTree;
PROCEDURE mImport (): tTree;
PROCEDURE mImport0 (): tTree;
PROCEDURE mImport1 (pNext: tTree): tTree;
PROCEDURE mFrom (pNext: tTree; pIdent: tIdent; pPos: tPosition; pImpIds: tTree): tTree;
PROCEDURE mObjects (pNext: tTree; pImpIds: tTree): tTree;
PROCEDURE mImpIds (): tTree;
PROCEDURE mImpIds0 (): tTree;
PROCEDURE mImpIds1 (pIdent: tIdent; pPos: tPosition; pNext: tTree): tTree;
PROCEDURE mExport (): tTree;
PROCEDURE mExport0 (): tTree;
PROCEDURE mExport1 (pQualified: BOOLEAN; pExpIds: tTree): tTree;
PROCEDURE mExpIds (): tTree;
PROCEDURE mExpIds0 (): tTree;
PROCEDURE mExpIds1 (pIdent: tIdent; pNext: tTree): tTree;
PROCEDURE mDecls (): tTree;
PROCEDURE mDecls0 (): tTree;
PROCEDURE mDecl (pNext: tTree): tTree;
PROCEDURE mVar (pNext: tTree; pVarIds: tTree; pType: tTree): tTree;
PROCEDURE mObject (pNext: tTree; pIdent: tIdent): tTree;
PROCEDURE mConst (pNext: tTree; pIdent: tIdent; pExpr: tTree): tTree;
PROCEDURE mTypeDecl (pNext: tTree; pIdent: tIdent; pType: tTree; pPos: tPosition): tTree;
PROCEDURE mProc (pNext: tTree; pIdent: tIdent; pFormals: tTree; pResultType: tTree; pDecls: tTree; pStmts: tTree): tTree;
PROCEDURE mProcHead (pNext: tTree; pIdent: tIdent; pFormals: tTree; pResultType: tTree; pPos: tPosition): tTree;
PROCEDURE mModule (pNext: tTree; pIdent: tIdent; pImport: tTree; pExport: tTree; pDecls: tTree; pStmts: tTree): tTree;
PROCEDURE mOpaque (pNext: tTree; pIdent: tIdent): tTree;
PROCEDURE mVarIds (): tTree;
PROCEDURE mVarIds0 (): tTree;
PROCEDURE mVarIds1 (pIdent: tIdent; pNext: tTree): tTree;
PROCEDURE mFormals (): tTree;
PROCEDURE mFormals0 (): tTree;
PROCEDURE mFormals1 (pIsVAR: BOOLEAN; pParIds: tTree; pType: tTree; pNext: tTree): tTree;
PROCEDURE mParIds (): tTree;
PROCEDURE mParIds0 (): tTree;
PROCEDURE mParIds1 (pIdent: tIdent; pNext: tTree): tTree;
PROCEDURE mType (): tTree;
PROCEDURE mArray (pIsOpen: BOOLEAN; pIndexType: tTree; pElemType: tTree): tTree;
PROCEDURE mRecord (pFields: tTree): tTree;
PROCEDURE mSetType (pBaseType: tTree): tTree;
PROCEDURE mPointer (pTargetType: tTree): tTree;
PROCEDURE mProcType (pFormalTypes: tTree; pResultType: tTree): tTree;
PROCEDURE mSimpleType (): tTree;
PROCEDURE mEnumeration (pEnumIds: tTree): tTree;
PROCEDURE mSubrange (pBaseType: tTree; pLwb: tTree; pUpb: tTree): tTree;
PROCEDURE mPrimaryType (): tTree;
PROCEDURE mVoid (): tTree;
PROCEDURE mTypeId (pIdent: tIdent; pPos: tPosition): tTree;
PROCEDURE mTypeId0 (pIdent: tIdent; pPos: tPosition): tTree;
PROCEDURE mTypeId1 (pIdent: tIdent; pPos: tPosition; pTypeId: tTree): tTree;
PROCEDURE mFields (): tTree;
PROCEDURE mFields0 (): tTree;
PROCEDURE mFields1 (pNext: tTree): tTree;
PROCEDURE mRecordSect (pNext: tTree; pFieldIds: tTree; pType: tTree): tTree;
PROCEDURE mVariantSect (pNext: tTree; pTagField: tTree; pVariants: tTree; pElse: tTree): tTree;
PROCEDURE mFieldIds (): tTree;
PROCEDURE mFieldIds0 (): tTree;
PROCEDURE mFieldIds1 (pIdent: tIdent; pNext: tTree): tTree;
PROCEDURE mTagField (pType: tTree): tTree;
PROCEDURE mTagField0 (pType: tTree): tTree;
PROCEDURE mTagField1 (pType: tTree; pIdent: tIdent): tTree;
PROCEDURE mVariants (): tTree;
PROCEDURE mVariants0 (): tTree;
PROCEDURE mVariant (pLabels: tTree; pVariant: tTree; pNext: tTree): tTree;
PROCEDURE mFormalTypes (): tTree;
PROCEDURE mFormalTypes0 (): tTree;
PROCEDURE mFormalType (pIsVAR: BOOLEAN; pType: tTree; pNext: tTree): tTree;
PROCEDURE mEnumIds (): tTree;
PROCEDURE mEnumIds0 (): tTree;
PROCEDURE mEnumIds1 (pIdent: tIdent; pNext: tTree): tTree;
PROCEDURE mExpr (): tTree;
PROCEDURE mBinary (pOperator: SHORTCARD; pLop: tTree; pRop: tTree): tTree;
PROCEDURE mUnary (pOperator: SHORTCARD; pMop: tTree): tTree;
PROCEDURE mIntConst (pKind: SHORTCARD; pIntVal: CARDINAL; pPos: tPosition): tTree;
PROCEDURE mRealConst (pRealVal: tStringRef): tTree;
PROCEDURE mStringConst (pStringVal: tStringRef): tTree;
PROCEDURE mCharConst (pCharVal: CHAR): tTree;
PROCEDURE mFuncCall (pDesignator: tTree; pActuals: tTree): tTree;
PROCEDURE mSet (pBaseType: tTree; pElems: tTree): tTree;
PROCEDURE mBitSet (pElems: tTree): tTree;
PROCEDURE mDesignator (pPos: tPosition): tTree;
PROCEDURE mQualid (pPos: tPosition; pIdent: tIdent): tTree;
PROCEDURE mQualid0 (pPos: tPosition; pIdent: tIdent): tTree;
PROCEDURE mQualid1 (pPos: tPosition; pIdent: tIdent; pQualid: tTree): tTree;
PROCEDURE mSubscript (pPos: tPosition; pDesignator: tTree; pIndex: tTree): tTree;
PROCEDURE mDeref (pPos: tPosition; pDesignator: tTree): tTree;
PROCEDURE mSelect (pPos: tPosition; pDesignator: tTree; pField: tIdent): tTree;
PROCEDURE mElems (): tTree;
PROCEDURE mElems0 (): tTree;
PROCEDURE mElems1 (pNext: tTree): tTree;
PROCEDURE mElem (pNext: tTree; pElem: tTree): tTree;
PROCEDURE mElemRange (pNext: tTree; pLwb: tTree; pUpb: tTree): tTree;
PROCEDURE mActuals (): tTree;
PROCEDURE mActuals0 (): tTree;
PROCEDURE mActual (pExpr: tTree; pNext: tTree): tTree;
PROCEDURE mStmts (): tTree;
PROCEDURE mStmts0 (): tTree;
PROCEDURE mStmt (pNext: tTree): tTree;
PROCEDURE mAssign (pNext: tTree; pDesignator: tTree; pExpr: tTree): tTree;
PROCEDURE mCall (pNext: tTree; pDesignator: tTree; pActuals: tTree): tTree;
PROCEDURE mIf (pNext: tTree; pCond: tTree; pThen: tTree; pElsifs: tTree; pElse: tTree): tTree;
PROCEDURE mCase (pNext: tTree; pExpr: tTree; pCases: tTree; pElse: tTree; pDefault: BOOLEAN): tTree;
PROCEDURE mWhile (pNext: tTree; pCond: tTree; pStmts: tTree): tTree;
PROCEDURE mRepeat (pNext: tTree; pStmts: tTree; pCond: tTree): tTree;
PROCEDURE mLoop (pNext: tTree; pStmts: tTree): tTree;
PROCEDURE mFor (pNext: tTree; pQualid: tTree; pFrom: tTree; pTo: tTree; pBy: tTree; pStmts: tTree): tTree;
PROCEDURE mWith (pNext: tTree; pDesignator: tTree; pStmts: tTree): tTree;
PROCEDURE mExit (pNext: tTree): tTree;
PROCEDURE mReturn1 (pNext: tTree): tTree;
PROCEDURE mReturn2 (pNext: tTree; pResult: tTree): tTree;
PROCEDURE mElsifs (): tTree;
PROCEDURE mElsifs0 (): tTree;
PROCEDURE mElsifs1 (pCond: tTree; pStmts: tTree; pNext: tTree): tTree;
PROCEDURE mCases (): tTree;
PROCEDURE mCases0 (): tTree;
PROCEDURE mCases1 (pLabels: tTree; pStmts: tTree; pNext: tTree): tTree;
PROCEDURE mLabels (): tTree;
PROCEDURE mLabels0 (): tTree;
PROCEDURE mLabels1 (pNext: tTree): tTree;
PROCEDURE mLabel (pNext: tTree; pLabel: tTree): tTree;
PROCEDURE mLabelRange (pNext: tTree; pLwb: tTree; pUpb: tTree): tTree;

PROCEDURE ReverseTree	(Tree: tTree): tTree;
PROCEDURE BeginTree;
PROCEDURE CloseTree;

END Tree.
