(**************************************************************************
** This program copies characters from the input file to the output file.
**
** Syntax: ivm type [in [out]]
**    where 'in' is the name of the input file. If 'in' is omitted then
**          the standard input stream is used.
**    and  'out' is the name of the output file. If 'out' is omitted then
**         the standard output stream is used.
*)
program typ(f, out);
var
   f, out : text;
   c : char;
begin
   reset(f);            (* Open name or the standard input *)
   rewrite(out);
   while not eof(f) do
      if eoln(f) then
         begin
            readln(f);
            writeln(out)
         end
      else
         begin
            read(f, c);
            write(out, c)
         end
end.
