/*
$Log:   uxhandles.c,v $
 * Revision 1.6  94/01/18  13:24:30  mboss
 * Fixed minor typo.
 * 
 * Revision 1.5  94/01/12  15:31:13  mboss
 * Added modifications for Windows NT platform.
 * 
 * Revision 1.4  93/10/27  08:43:43  mboss
 * Addition of Alpha code modifications.  In most places type int and
 * unsigned int have been changed to long and unsigned long.  On 32 bit
 * machines int = long and unsigned = unsigned long.
 * 
 * Revision 1.2  93/03/25  12:06:53  mboss
 * Added Solaris customisation.
 * 
 * Revision 1.1  93/03/10  09:40:56  mboss
 * Initial revision
 * 
*/
/*  ***********************************************************************
    *                                                                     *
    *               Modula-2 UxHandles Libary Implementation              *
    *                                                                     *
    *                     C code of Uxhandles routines                    *
    *                                                                     *
    *       (c) copyright  1988 Faculty of Information Technology         *
    *                                                                     *     
    *           original module :   -Mar-91 kjg                           * 
    *           modifications   :   -Apr-91 kjg non ANSI version          *
    *                             29-Apr-91 kjg Flush both stream s, and  *
    *                                           _iob[fileno(s)], this     *
    *                                           allows for the possibility*
    *                                           that writing has been to  *
    *                                           the original buffer rather*
    *                                           than the buffer provided  *
    *                                           StreamOfHandle()          *
    *                           : 18-Feb-93 pms merged platform specific  *
    *                                           files                     *
    *                           : 04-Mar-93 pms Deleted machine.cpp.      *
    *                                           Specific code obtained    *
    *                                           via cc switches in        *
    *                                           COMPILEcsrc               *
    *                           : 24-Mar-93 pms Added Solaris changes     *
    *                           : 20-Dec-93 pms Added Windows NT changes  *
    ***********************************************************************
*/


#include <fcntl.h>
#include <stdio.h>

#ifdef djgpp
#  define DOS_FILES
#endif
#ifdef os2
#  define DOS_FILES
#endif
#ifdef winnt
#  define DOS_FILES
#  define O_BINARY _O_BINARY
#  define O_TEXT   _O_TEXT
#  define S_IREAD  _S_IREAD
#  define S_IWRITE _S_IWRITE
#  define stat     _stat
#  define fstat    _fstat
#  define setmode  _setmode
#endif
#ifdef DOS_FILES
#  include <io.h>
#  include <sys\types.h>
#  include <sys\stat.h>
     typedef int FileDesc;
     static char __fm__[6][4] = {"rb", "wb", "r+b", "rt", "wt", "r+t"};
#else
     typedef short int FileDesc;
     static char __fm__[3][3] = {"r", "w", "r+"};
#endif


/* *************** UxHandles_OpenFileHandle () *************** */

#ifdef KandR_C
    FileDesc  UxHandles_OpenFileHandle (path, high, mode)
    char * path;
    unsigned long high; /* ignored */
    char mode;
#else
    FileDesc  UxHandles_OpenFileHandle (char * path, unsigned long high, 
					char mode)
#endif

{
    int oflag;
# ifdef DOS_FILES
    if ((mode % 3) == 0) return (open(path,O_RDONLY));
    else {
	if ((mode % 3) == 1) oflag = O_WRONLY | O_CREAT;
	else oflag = O_RDWR | O_CREAT;
	return (open(path,oflag | ((mode < 3) ? O_BINARY: O_TEXT ),
		    S_IREAD | S_IWRITE));
# else
    if (mode == 0) return (open(path,O_RDONLY));
    else {
	if (mode == 1) oflag = O_WRONLY | O_CREAT;
	else oflag = O_RDWR | O_CREAT;
	return (open(path,oflag,0666));
# endif
    }
}

/* *************** UxHandles_CloseHandle () *************** */

#ifdef KandR_C
    void UxHandles_CloseHandle (handle, ok)
    FileDesc handle; 
    char * ok;
#else
    void UxHandles_CloseHandle (FileDesc handle, char * ok)
#endif

{
    *ok = (close(handle) != -1);
}


/* *************** UxHandles_StreamOfHandle () *************** */

#ifdef KandR_C
    FILE * UxHandles_StreamOfHandle (fd)
    FileDesc fd;
#else
    FILE * UxHandles_StreamOfHandle (FileDesc fd)
#endif

{
   int flags;
# ifdef DOS_FILES
    struct stat info;
    int mode;
 
    fstat (fd, &info);
    flags = (info.st_mode & S_IWRITE) ? 2 : 0;
    mode = setmode (fd, O_BINARY);  /* This returns current mode */
    if (mode == O_TEXT)
    {
       flags += 3;
       setmode (fd, mode);           /* Set it back, if guessed wrong */
    }
# else
    flags = fcntl(fd,F_GETFL,0) & 03;
# endif
    return (fdopen(fd,__fm__[flags]));
}


/* *************** UxHandles_CloseStream () *************** */

#ifdef KandR_C
    void UxHandles_CloseStream (fil, ok)
    FILE * fil; 
    char * ok;
#else
    void UxHandles_CloseStream (FILE * fil, char * ok)
#endif

{
    *ok = (fclose(fil) != EOF);
}


/* *************** UxHandles_FlushStream () *************** */

#ifdef KandR_C
    void UxHandles_FlushStream (fil, ok)
    FILE * fil; 
    char * ok;
#else
    void UxHandles_FlushStream (FILE * fil, char * ok)
#endif

{
  /*
    *  flush twice, just in case writing has
    *  been done to the handle, rather than 
    *  the stream ...
    */
#ifndef linux
#ifndef djgpp
#ifndef os2
# ifdef solaris
       (void) fflush(&__iob[fileno(fil)]);
# else
#  ifdef i386
       (void) fflush(&__iob[fileno(fil)]);
#  else
       (void) fflush(&_iob[fileno(fil)]);
#  endif
# endif
#endif
#endif
#endif
       *ok = (fflush(fil) != EOF);
}


/* *************** UxHandles_RedirectHandle () *************** */

#ifdef KandR_C
    void UxHandles_RedirectHandle (old, new, save, done)
    FileDesc old;
    FileDesc new;
    FileDesc * save;
    char * done;
#else
    void UxHandles_RedirectHandle (FileDesc old, FileDesc new,
				   FileDesc * save, char * done)
#endif

{
    int dummy;

    *done = '\0';
    *save = dup(old);  if (*save == -1) return;
    dummy = close(old);if (dummy == -1) return;
    dummy = dup(new);  if (dummy != old) return;
    dummy = close(new);if (dummy == -1) return;
    *done = '\1';
}


/* *************** UxHandles_RestoreHandle () *************** */

#ifdef KandR_C
    void UxHandles_RestoreHandle (old, saved, done)
    FileDesc old;
    FileDesc saved;
    char * done;
#else
    void UxHandles_RestoreHandle (FileDesc old, FileDesc saved, char * done)
#endif

{
    int dummy;

    *done = '\0';
    dummy = close(old);if (dummy == -1) return;
    dummy = dup(saved);if (dummy != old) return;
    dummy = close(saved);  if (dummy == -1) return;
    *done = '\1';
}
