/*
$Log: textinout.c,v $
 * Revision 1.9  1994/11/29  00:41:11  mboss
 * Replaced eofReadTextIO logic with call to feof(), for more consistent
 * response
 *
 * Revision 1.8  1994/10/03  05:00:29  mboss
 * eofRead now eofReadTextIO to avoid conflict with InOut
 *
 * Revision 1.7  1994/09/29  23:10:55  mboss
 *  ReadString returns \0 at endof file (termCh)
 *
 * Revision 1.6  1994/05/22  23:25:36  mboss
 * ReadString returns \0 at endof file (termCh)
 *
 * Revision 1.5  1994/05/22  23:10:57  mboss
 * Added explicit termination for end of at end of file for ReadString
 *
 * Revision 1.4  1994/01/31  16:34:30  mboss
 * Fixed incorrect str lengths in WriteInt, WriteOct and WriteHex.
 *
 * Revision 1.3  93/10/27  08:43:40  mboss
 * Addition of Alpha code modifications.  In most places type int and
 * unsigned int have been changed to long and unsigned long.  On 32 bit
 * machines int = long and unsigned = unsigned long.
 * 
 * Revision 1.1  93/03/10  09:39:18  mboss
 * Initial revision
 * 
*/
/* 
    **********************************************************************
    *                                                                    *     
    *              Modula-2 Text InOut Libary Implementation             *
    *                                                                    *
    *                    C code of TextInOut routines                    *
    *                                                                    *
    *       (c) copyright  1988 Faculty of Information Technology        *
    *                                                                    *     
    *       original module : kjg august 1990                            *
    *       modifications   : 19-Dec-90 pjk ReadInt & ReadCard revised   *
    *                       :  7-Mar-91 kjg table must be declared static*
    *                       : 18-Mar-92 jrh Write field widths > 22      *
    *                       :  6-Feb-93 pms Merged all platform specific *
    *                                       files into one file          *
    *                       : 04-Mar-93 pms Deleted machine.cpp.         *
    *                                       Specific code obtained via   *
    *                                       cc switches in COMPILEcsrc   *
    *                       : 13-Oct-93 pms Added Alpha specifics        *
    *                       : 31-Jan-94 pms Fixed incorrect str length   *
    *                                       in WriteInt,Hex,Oct          *
    *                       : 19-May-94 pms Fixed ReadString loop at EOF *
    *                       : 23-May-94 pms ReadString returns \0 at EOF *
    *                       : 02-Aug-94 pms ReadXXX all return Done at   *
    *                                       EOF - compatible with PC     *
    *                       : 03-Oct-94 pms eofRead now eofReadTextIO to *
    *                                       avoid conflict with InOut    *
    *                       : 29-Nov-94 pms eofReadTextIO removed and re *
    *                                       -placed with call to feof()  *
    *                                                                    *
    **********************************************************************
*/


#include <stdio.h>
#ifdef ANSI_C
#include <string.h>
#endif

#define TRUE 1
#define FALSE 0

     typedef char bool;

#ifdef KandR_C
     typedef char un_chr;
#else
#  ifdef _APOLLO_SOURCE 
     typedef char un_chr;
#  else
     typedef unsigned char un_chr;
#  endif
#endif


/* Variables for TextInOut */

un_chr TextInOut_termCh;
bool TextInOut_Done;  
/*
 *      Max CARDINAL (unsigned long int) on the alpha is 20 characters
 *      (2^64 - 1) and 10 characters (2^32 - 1) on other platforms.
 *      Max INTEGER (long int) on the alpha is also 20 characters long
 *      (-2^63) including the sign.  On other platforms (-2^31) it is 
 *      11 characters long, including the sign.  Max CARDINAL in octal
 *      is 22 characters long on the alpha and 11 characters on other
 *      platforms.  Therfore a string length of 24 (including a leading
 *      space - to allow termination of while loops in Writexxx - and NULL 
 *      terminator) is used for Alpha and 13 for other platforms.  A
 *      limit of 256 is placed on the field width for all Writexxx. 
 */
# ifdef alpha
#   define MAXLEN 22
    static char numStr[] = "                      0";  
 /*                          1777777777777777777777  <- Octal */
#   define MAXINT               9223372036854775807
#   define MAXCARD             18446744073709551615
# else
#   define MAXLEN  11
    static char numStr[] = "           0";
 /*                          37777777777  <- Octal */
#   define MAXINT             2147483647
#   define MAXCARD            4294967295
# endif

static char table[17] = "0123456789abcdef"; /* hex translation array */

/* *************** TextInOut_Read () *************** */

#ifdef KandR_C
    void TextInOut_Read (f, c)
    FILE *f;
    un_chr *c;
#else
    void TextInOut_Read (FILE *f, un_chr *c)
#endif
    
{
 int iVar;
 
 if (feof(f))                           /* was if (eofReadTextIO - Nov 94) */
   TextInOut_Done = FALSE;              /* Aug 94 */
 else
 {
    TextInOut_Done = TRUE;
    *c = (un_chr) (iVar = getc(f));
    if (iVar == EOF) {
      TextInOut_Done = FALSE;
      *c = '\0';                 /* was *c = NULL - KandR_C */
    }                            /*   & *c = 0    - ANSI_C */
 }
}

/* *************** TextInOut_ReadString () *************** */

#ifdef KandR_C
    void TextInOut_ReadString (from, s, _s_s)
    FILE *from;
    un_chr s[];
    unsigned long _s_s;
#else
    void TextInOut_ReadString (FILE *from, un_chr s[], unsigned long _s_s)
#endif
{
 long int i;
 un_chr c;
/*
 * Loops below should terminate on (control) characters < ' ';
 * however EOF = -1 = 255 will test > ' ', causing the leading white
 * space loop to fill the string with EOFs and the trailing discard loop
 * to loop forever;
 * so add explicit tests for EOF.
 */
#define uEOF (un_chr) EOF

if (feof(from))                           /* was if (eofReadTextIO - Nov 94) */
   TextInOut_Done  = FALSE;
else
{
  while  ( (c=getc(from)) == ' ' || c == '\t' ) ;
        /* skips  leading white space */

  s[0] = c ; i = 0;
  if ((s[0] = c) == uEOF)               /* Aug 94 */
  {
      TextInOut_termCh = c;
  }
  else
  {
     /* read string until blank or control character or _s_s+1 characters */

     while ( i < _s_s && s[i] > ' ' && c != uEOF )
        s[++i] = getc(from);

     if ( (i < _s_s) || ( (i == _s_s) && ((s[i] <= ' ') || (s[i] ==uEOF )))){
        TextInOut_termCh= s[i]; 
        s[i]='\0'; } /* terminate short string with null */
     else { /* discard excess characters if any */
        while ( ( c=getc(from)) > ' '  && c != uEOF)
          ; 
           TextInOut_termCh = c;  }
     TextInOut_Done = TRUE;                  /* Nov 94 */
     if (c == uEOF)
     {
       TextInOut_termCh = '\0';
     }
  }
}
}

/* *************** TextInOut_ReadCard () *************** */

#ifdef KandR_C
    void TextInOut_ReadCard (from, n)
    FILE *from;
    unsigned long *n;
#else
    void TextInOut_ReadCard (FILE *from, unsigned long *n)
#endif
{ 
  unsigned char  c,noOvflo; 
  unsigned long nd,nn ;

  noOvflo=TRUE;
                                    /* was if (eofReadTextIO - Nov 94) */
  if (feof(from))                   /* Aug 94 */
     TextInOut_Done = FALSE;
  else 
  {
     while  ( (c=getc(from)) == ' ' || c == '\t' ) 
        ;   /* skips  leading white space */

    if ( c >= '0' && c <= '9') {
        nd = 0 ;
        do {
            nn = nd * 10 + (unsigned long)( c - '0');
            if ((nd > (MAXCARD / 10)) || (nn<nd)) noOvflo=FALSE;
            c = getc(from);
            nd=nn;
           }
        while ( c >= '0' && c <= '9');
        *n = nd;
        TextInOut_Done = noOvflo ;
        TextInOut_termCh = c;
    }
    else {
        TextInOut_Done = FALSE;
        TextInOut_termCh = c;
         }
  }
}


/* *************** TextInOut_ReadInt () *************** */

#ifdef KandR_C
    void TextInOut_ReadInt(from, i)
    FILE *from;
    long int *i ;
#else
    void TextInOut_ReadInt(FILE *from,long int *i)
#endif
{
 long int nd, nn;
 unsigned char c, first, ovflo;

 if (feof(from))                           /* was if (eofReadTextIO - Nov 94) */
     TextInOut_Done = FALSE;
 else
 {
    while ( (c=getc(from)) == ' ' || c=='\t' ) ;
            /* skips  leading white space */

    first = c;
    ovflo = FALSE;

    if (c == '+' || c == '-') c=getc(from);

    if ( c >= '0' && c <= '9') {
       nd = 0 ;
       do {
            nn = nd * 10 + (long int)(c - '0');
            if (nd > (MAXINT / 10)) ovflo = TRUE;  /* ==> maxint DIV 10 */
            nd = nn;
            c=getc(from);
          }
       while ( c >= '0' && c <= '9') ;
       
       if (first == '-')  {
            nd = - nd;
            if ((nd <= 0) && !ovflo) TextInOut_Done = TRUE;
            else TextInOut_Done = FALSE;
       }
       else {
            if ((nd >= 0) && !ovflo) TextInOut_Done = TRUE;
            else TextInOut_Done = FALSE;
       }
       TextInOut_termCh = c;
       *i   = nd;
    }
    else {
       TextInOut_Done = FALSE;
       TextInOut_termCh = c;
    }
 }
}

/* *************** TextInOut_Write () *************** */

#ifdef KandR_C
    void TextInOut_Write (to, c)
    FILE * to;
    un_chr c;
#else
    void TextInOut_Write (FILE *to,un_chr c)
#endif

{
 putc( (c),to);
}

/* *************** TextInOut_WriteLn () *************** */

#ifdef KandR_C
    void TextInOut_WriteLn (to)
    FILE *to;
#else
    void TextInOut_WriteLn (FILE *to)
#endif

{
 putc( ('\n'), to);
}

/* *************** TextInOut_WriteString () *************** */

#ifdef KandR_C
    void TextInOut_WriteString (to, _p_s, _s_s)
    FILE *to;
    un_chr *_p_s;
    unsigned long _s_s;
#else
    void TextInOut_WriteString (FILE *to, un_chr *_p_s, unsigned long _s_s)
#endif
{
  long int i ;

  for ( i= 0; i <= _s_s && _p_s[i] != '\0' ; putc( (_p_s[i++]), to))
    ;
}


/* *************** TextInOut_WriteCard () *************** */

#ifdef KandR_C
    void TextInOut_WriteCard (to, num ,len)
    FILE *to;
    unsigned long num;
    unsigned long len;
#else
    void TextInOut_WriteCard (FILE *to, unsigned long num ,unsigned long len)
#endif

{
    unsigned long ix;
    char str[MAXLEN+2];

    strcpy(str, numStr); 
    ix = MAXLEN;
    while (num > 0){
        str[ix] = (num % 10 + 060);
        num = num / 10;
        ix--;
    }
    if (len > 256) len = 256;
    while (len > MAXLEN)  { putc(' ',to); len--; }
    while (str[MAXLEN - len] != ' ')  len++;
    fputs(&str[MAXLEN + 1 - len],to);
}

/* *************** TextInOut_WriteInt () *************** */

#ifdef KandR_C
    void TextInOut_WriteInt (to, val ,len)
    FILE *to;
    long int val;
    unsigned long len;
#else
    void TextInOut_WriteInt (FILE *to, long int val ,unsigned long len)
#endif

{
    unsigned long num;
    unsigned long ix;
    char str[MAXLEN+2];
 
    strcpy(str, numStr);
    num = (val < 0 ? -val : val);
    ix = MAXLEN;
    while (num > 0){
        str[ix] = (num % 10 + 060);
        num = num / 10;
        ix--;
    }
    if (val < 0) str [ix ] = '-';
    if (len > 256) len = 256;
    while (len > MAXLEN)  { putc (' ',to);  len--; }
    while ( str[MAXLEN - len] != ' ')  len++;
    fputs(&str[MAXLEN + 1 - len],to);
}

/* *************** TextInOut_WriteOct () *************** */

#ifdef KandR_C
    void TextInOut_WriteOct (to, num, len)
    FILE *to;
    unsigned long num;
    unsigned long len;
#else
    void TextInOut_WriteOct (FILE *to, unsigned long num, unsigned long len)
#endif
{
    unsigned long ix;
    char str[MAXLEN+2];
 
    strcpy(str, numStr);
    ix = MAXLEN;
    while (num > 0){
        str[ix] = (num % 8 + 060);
        num = num / 8;
        ix--;
    }
    if (len > 256) len = 256;
    while (len > MAXLEN) { putc(' ',to);  len--; }
    while ( str[MAXLEN - len] != ' ')  len++;  
    fputs(&str[MAXLEN + 1 - len],to);
}

/* *************** TextInOut_WriteHex () *************** */

#ifdef KandR_C
    void TextInOut_WriteHex (to, num, len)
    FILE *to;
    unsigned long num;
    unsigned long len;
#else
    void TextInOut_WriteHex (FILE *to, unsigned long num, unsigned long len)
#endif

{
    unsigned long ix;
    char str[MAXLEN+2];
 
    strcpy(str, numStr);
    ix = MAXLEN;
    while (num > 0){
        str[ix] = table[num % 16];
        num = num / 16;
        ix--;
    }
    if (len > 256)  num = 256;
    while (len > MAXLEN) { putc(' ',to); len--; }
    while ( str[MAXLEN - len] != ' ') len++;
    fputs(&str[MAXLEN + 1 - len],to);
}
