/*
$Log:	asciitime.c,v $
 * Revision 1.5  94/01/12  15:27:22  mboss
 * Added modifications for Windows NT platform.
 * 
 * Revision 1.4  93/10/27  08:41:03  mboss
 * Addition of Alpha code modifications.  In most places type int and
 * unsigned int have been changed to long and unsigned long.  On 32 bit
 * machines int = long and unsigned = unsigned long.
 * 
 * Revision 1.3  93/03/25  11:11:42  mboss
 * Added solaris implementation.
 * 
 * Revision 1.2  93/03/10  09:13:54  mboss
 * Moved platform specific comments inside appropriate
 * #defines.  Allows specific source files to be generated without
 * unrelated comments.
 * 
 * Revision 1.1  93/03/10  09:12:09  09:12:09  mboss (Mr GPM Modula2)
 * Initial revision
 * 
*/
/*  *************************************************************************
    *                                                                       *
    *              Modula-2 AsciiTime Libary Implementation                 *
    *                                                                       *
    *                    C code of AsciiTime routines                       *
    *                                                                       *
    *   (c) copyright  1991 Faculty of Information Technology               *
    *                                                                       *
    *      original module : pjk Dec 1990                                   *
    *      modifications   : pms Jan 1993 - Generic routine for all         *  
    *                                       platforms.  Uses machine.cpp    *
    *                                       for platform specfic details    *
    *                        pms 04-Mar-93  Removed reference to            *
    *                                       machine.cpp. Specfic code now   *
    *                                       from cc switches in COMPILEcsrc *
    *                        pms 10-Mar-93  Moved platform specific comments*
    *                                       inside #defines                 *
    *                        pms 18-May-93  Added bsd details for Apollo    *
    *                        pms 13-Oct-93  Added Alpha details             *
    *                        pms 16-Dec-93  Added Windows NT details        * 
    *                                                                       *
    *************************************************************************
    */


# ifdef _APOLLO_SOURCE
#  ifndef opsys_bsd
#    include <time.h>
#  endif
# else
#    include <time.h>
# endif

/*
        If the platform operating system is BSD UNIX or the platform is 
        iris (Silicon Graphics), Intel (i386), DEC Alpha or Solaris then 
        include <sys/time.h>.
*/
# ifdef opsys_bsd
#    include <sys/time.h>
# endif
# ifdef iris
#    include <sys/time.h>
# endif
# ifdef solaris 
#    include <sys/time.h>
# endif
# ifdef linux
#    include <sys/time.h>
# endif
# ifdef djgpp
#    include <sys/time.h>
# endif
# ifdef os2
#    include <sys/time.h>
# endif
# ifdef i386 
#    include <sys/time.h>
# endif
# ifdef alpha
#    include <sys/time.h>
# endif
# ifdef winnt
#    include <time.h>
#    include <sys\types.h>
#    include <sys\timeb.h>
# endif



# ifdef sun68k
  /*
        Sun C does not appear to know about
        time_t
  */ 
    typedef long time_t;
# endif 

    /************************************************
    --    The C representation of the DateTime TYPE
    --    used for storing the present date and time.
    ************************************************/
    
    typedef struct {
                    unsigned year;
                    unsigned char month;
                    unsigned char day;
                    unsigned char hour;
                    unsigned char minute;
                    unsigned char second;
                    unsigned char fractions;
                    short    int  zone;
                    unsigned char SummerTimeFlag;
                    } DateTime;
       
     
 
#ifdef _APOLLO_SOURCE
    /*
          Apollo has 2 flavours "bsd" and "sysV".
          Definition of "apolSysV" makes obtaining the
          right code easier.
    */
#  ifdef opsys_sysV
#      define apolSysV
#  endif
#endif

    /************************************************
         AsciiTime_TimeToStructTime
          -- This procedure is used to produce 
          -- a DateTime structure.
    ************************************************/

# ifdef KandR_C
     void AsciiTime_TimeToStructTime (time, userData)
#  ifdef sun68k
       time_t time;
#  else
#    ifdef Sparc
       time_t time;
#    else
       unsigned time;
#    endif
#  endif
       DateTime *userData;
# else
     void AsciiTime_TimeToStructTime (unsigned time, DateTime *userData)
# endif
    
    {
      struct tm  *timeStruct;
#  ifdef apolSysV
      timeStruct = localtime ((int *) &time);
#  else
#    ifdef winnt
      struct _timeb zone;
      _ftime(&zone);
#    else
      struct timezone  zone;
      struct timeval   m2time;
    
      gettimeofday(&m2time,&zone);
#    endif
#   ifdef _APOLLO_SOURCE
      timeStruct = localtime((int *) &time);
#   else
      timeStruct = localtime(&time);
#   endif
#  endif
      userData -> year   = timeStruct -> tm_year + 1900;
      userData -> month  = (unsigned char) timeStruct -> tm_mon +1;
      userData -> day    = (unsigned char) timeStruct -> tm_mday;
      userData -> hour   = (unsigned char) timeStruct -> tm_hour;
      userData -> minute = (unsigned char) timeStruct -> tm_min;
      userData -> second = (unsigned char) timeStruct -> tm_sec;
      userData -> fractions = 0;
#  ifdef apolSysV
      userData -> zone = timezone;
#  else
#    ifdef winnt
      userData->zone = zone.timezone;
#    else 
      userData -> zone = (int) (zone.tz_minuteswest);
#    endif
#  endif
      userData -> SummerTimeFlag = (unsigned char)(timeStruct -> tm_isdst );
   }
    
    
    static char Month[12][4] = { "Jan","Feb","Mar","Apr","May","Jun",
                     "Jul","Aug","Sep","Oct","Nov","Dec"};
    
    
    /************************************************************
                CardToString
    -- The following procedure produces the string representation
    -- of a cardinal number. The procedure is given the starting
    -- index into the supplied array, the value required, the 
    -- array in which to insert the string,and the minimum size
    -- of the output string length. if the output string has less
    -- digits than the required size the output is padded with 
    -- '0' to produce a string of the correct length.
    ************************************************************/ 
        
#   ifdef KandR_C
        void CardToString (index, val, str, _s_s, size)
        unsigned *index;
        unsigned val;
        char     str[];
        unsigned _s_s;
        int      size;
#   else
        void CardToString (unsigned *index, unsigned val, char str[],
                           unsigned _s_s, int size)
#   endif

    {
      unsigned  digit,newval;
      int i;
    
       digit = val % 10;
       newval = val /10;
       if (newval >0)
            CardToString(index,newval, str,_s_s,size-1);
       if (newval==0) for(i=1;i<size;i++) str[(*index)++] = '0'; 
       if (*index <= _s_s) str[(*index)++] = digit + '0';
         
    }
    
    /******************************************************
            AsciiTime_StructTimeToAscii
    -- This procedure generates the date string.
    ******************************************************/
    
#   ifdef KandR_C
        void AsciiTime_StructTimeToAscii (str, _s_s, time)
        char     str[];
        unsigned _s_s;
        DateTime time;
#   else
        void  AsciiTime_StructTimeToAscii (char str[], unsigned   _s_s,
                                           DateTime time)
#   endif
    { 
      unsigned i,strIndex=0;
      char     temp[22];
    
      CardToString(&strIndex,time.year,temp,22,4);
      temp[strIndex++] = ' ';
      temp[strIndex++] = Month[time.month-1][0];
      temp[strIndex++] = Month[time.month-1][1];
      temp[strIndex++] = Month[time.month-1][2];
      temp[strIndex++] = ' ';
      CardToString(&strIndex,time.day,temp,22,2);
      temp[strIndex++] = ' ';
      CardToString(&strIndex,time.hour,temp,22,2);
      temp[strIndex++] = ':';
      CardToString(&strIndex,time.minute,temp,22,2);
      temp[strIndex++] = ':';
      CardToString(&strIndex,time.second,temp,22,2);
      temp[strIndex++] = '\0';
      for(i=0; i<=_s_s && i<strIndex;i++) str[i]=temp[i];
    } 
