.\" $Header: gpm.1,v 2.22 88/04/06 11:48:07 mee content6 $
.\" @(#) gpm.1 1.4  @(#)gpm.1	1.4  12/11/85  1   
.TH GPM 1 "" "" HP-UX
.SH NAME
gpm \- gardens point modula compiler 
.SH SYNOPSIS
.br
.B gpm
[
.B \-options
]
.I file ...
.SH DESCRIPTION
.B gpm
is a Modula-2 compiler for 32-bit UNIX machines. 
It provides comprehensive compile\-time
diagnostics, with explicit error messages, and optional warnings for
obsolete syntax or dubious program constructs. In addition, it allows
seamless integration with standard UNIX tools such as
.B prof
and
.B dbx
and a safe interface to libraries such as
.B curses
\&.


.SS Compiling a program module

A program module is the single simplest compilation unit containing all
declarations and program statements with perhaps an importation from one
or more modules. Assuming you have a source file hello.mod, the simplest
command line is	

.B gpm hello.mod

The output would be an object file,
.B hello.o 
and a reference file,
.B hello.rfx
\&.
 

.SS Compiling a definition module

A definition module (
.B .def
) is a separate compilation unit defining the interface
between a module and its environment. Its contains all the information that
the compiler needs to verify that another module is correctly using the
facilities provided by this module.
 
The command

.B gpm myfile.def

will produce a symbol file, with extension  
.B .syx
\&.
 
A definition module must be compiled before the corresponding implementation
module. The definition module should also be compiled before any program or
module that imports objects from that module.


.SS Compiling an implementation module

An implementation module (
.B .mod
) contains the procedure bodies and
initialization statements together with any other hidden procedure or
data declarations.

The command	

.B gpm myfile.mod

will produce an object file, with extension 
.B .o
, and a reference file,
with extension 
.B .rfx
\&.

Since an implementation module depends on its own definition module and
those other definition modules from which it imports some facility, an
implementation module cannot be compiled until all such definition modules have
been compiled. During compilation, symbol files for imported modules 
are accessed, looking first in the current directory and then on the
directories of the path
.B $M2SYM
\&.
All module names will be 
moved to lower case before any extension is appended.


.SS Multiple files

.B gpm
accepts multiple filename arguments from the command line. 
It will repeatedly invoke the compiler to compile each file named.
The same options are passed to each invocation of the compiler.
It is possible to use the normal shell expansions of filename
metacharacters to compile multiple files.
For example

.B gpm `grep -l Terminal *.mod`

would recompile all files in the current directory with filename 
extension .mod, and which mention the library
.I Terminal
\&.

.SS Command-line Options
.PP
.B gpm  
provides many options to control the operation of the
compiler and the format of messages produced during compilation. The syntax
for options flags follows closely the style used by UNIX commands.

If any options are to be passed, they must be in option strings which 
appear between the command and the filename(s).
.B gpm 
Option strings must start with a minus sign 
.B \-
and all options may appear in arbitrary order in arbitrary groups.
The order of the options is never important, so that 
.B gpm -IirOfS foo.mod
and 
.B gpm -S -Of -irI foo.mod
have precisely the same effect.
.PP
.B \-a	\t
assertion\-off \- assertion tests in the source code, invoked by the system
procedure
.B ProgArgs.Assert
are ignored by the compiler and generate no code
.PP
.B \-d	\t
dangerous \- warning messages to the screen and list file (if selected) 
are suppressed. However, if a program has both errors
.B and
warnings both will go to the screen and listings in spite of the
.B \-d \t
option
.br
.PP
.B \-f	\t
filename \- force the compiler to name reference and object files based
on the source filename rather than the module 
name. This option is illegal when applied to program 
modules. This option allows several implementations of the same 
module to exist in the same directory, and to be selectively 
linked using the query option 
.B \-q 
of 
.B build
.br
.PP
.B \-g	\t
intermediate code is compiled with markers for the debuggers
.B  adb dbx xdb
\&. This option is not required for simply obtaining a post-mortem 
procedure call\-chain listing
.br
.PP
.B \-I	\t
Interactive \- the compiler 
halts on errors, displays the verbose version of the diagnostic, 
and prompts the user to continue, quit, or jump into the
.B vi
editor
.br
.PP
.B \-i	\t
array index tests are turned off  (same as 
.B (*$I\-*) 
in the source file)
.br
.PP
.B \-l	 \t
a list file 
.B name.lst
is generated from input file 
.B name.def
or 
.B name.mod
.br
.PP
.B \-n	\t
no\-code \- the compiler 
performs syntactic and semantic checking, but  
no object code is produced. This allows a speedy check of modified
code, before a complete recompilation is attempted
.br
.PP
.B \-Oc	 \t
Optimise so as to produce compact code, even at the price   
of small speed loss (same as 
.B (*$C+*)
in the source file).
.br
.PP
.B \-Of	\t
Optimise so as to produce fast code, even at the price of 
larger memory size. This flag has a similar effect to the 
.B (*$F+*)
in the source file, but affects code generation strategy
as well as front-end program transformations. Use of this flag is
thus preferred to the use of the program switch statement
.br
.PP
.B \-p	\t
compile with profiling code so that 
.B bldprf
and
.B prof
can produce procedure call\-counts as well as time
statistics. If any modules of a program are compiled 
with this option, the program must be built with 
.B bldprf.
See the relevant chapter of the technical reference 
manual for more on the profiling facilities 
.br
.PP
.B \-r	\t
range checking of assigned values and actual value parameters is suppressed 
(same as 
.B (*$R\-*)
in the source file)
.br
.PP
.B \-S	\t
aSsembler \- the 
.B C
language intermediate code is persistent in the file  
.B name.c
, no object code is produced. This flag is only of use for debugging mixed 
language programs
.br
.PP
.B \-v	\t
verbose screen messages are produced, and verbose listings also, if 
.B \-l
is also specified
.br
.PP
.B \-V	\t
super\-Verbose \- the Version date and time of the compiler are displayed,
the key\-values of all directly and indirectly imported symbol 
modules are traced, and verbose messages and listings are produced.
Also, the absolute pathnames of imported symbol files are displayed.
