definition module MineTypes;


import StdInt, StdFile, deltaPicture, deltaFont, deltaWindow;
from StdString import String;

    

::	Minefield	:== [[Spot]];
::	Spot		=  Mine		 Visibility
				|  Empty Int Visibility;
::	Visibility	=  Visible | Invisible;
::	Pebbles		:== [Position];
::	Position	:== (Int,Int);
::	Time		=  Running Int | Off;
::	Dimension	:== (Int,Int);
::	* MinesBest	:== (Files, BestTimes);
::	BestTimes		:== (ThreeBest, ThreeBest, ThreeBest);
::	ThreeBest		:== (String,Int,String,Int,String,Int);
::	RandomSeed	:== Int;


     
	EasyDim	 :== (8,  8);	EasyMines	:== 10;
	InterDim :== (16,16);	InterMines	:== 40;
	HardDim	 :== (30,16);	HardMines	:== 99;

	SizeArea	:== 14;
	Minus x		:== 0 - x;


    

DrawCorrectnessPebble	::	Pebbles Spot Position -> DrawFunction;
DrawRevealedSpot	::		(Position, Spot)	  -> DrawFunction;

DrawNrMines	::		Font Int Dimension Picture -> Picture;
DrawTime	::		Font Int Dimension Picture -> Picture;
DrawEmptyArea	::	Position	  Picture -> Picture;
DrawPebble	::		Position	  Picture -> Picture;
DrawSpot	::		Spot Position Picture -> Picture;
DrawAnySpot	::		Spot Position Picture -> Picture;
DrawGrid	::		Dimension	  Picture -> Picture;

SowMines	::	Int Dimension RandomSeed -> (Minefield, RandomSeed);
GetSpot	:: 	Position Minefield -> Spot;
RevealSpot	::	Position Minefield -> (Spot, Minefield);

NulSpot	:: 	  Spot -> Bool;
MineSpot	::	  Spot -> Bool;
InvisibleSpot	:: Spot -> Bool;

RemovePebble	:: Position Pebbles -> Pebbles;

WindowPictDomain	:: Dimension -> PictureDomain;

TranslatePoint	:: Point Vector -> Point;
