/*
File: test.java
Description: Test Os2Mbx
Date: 29.Apr 1997
Author: Henrik Falk
        2:236/89@fidonet.org
        81:445/12@os2net.ftn
        hfalk@ibm.net

        Freeware!
*/

import java.awt.*;

/********************************************************************
* Class: sample1
********************************************************************/
public class sample1 extends Frame
{
  protected Button testButton;

  Os2Mbx msg;

  /******************************************************************
  * Method: main()
  ******************************************************************/
  public static void main(String args[])
  {

    sample1 mainApp=new sample1("Test Application");

            mainApp.resize(400,200);
            mainApp.show();

  } // end method main()

  /******************************************************************
  * Constructor: sample1()
  ******************************************************************/
  public sample1(String mainTitle)
  {

    super(mainTitle);

    testButton=new Button("Test me!");

    Panel c=new Panel();

          c.setLayout(new FlowLayout());
          c.add(testButton);

    this.add("Center",c);

  msg=new Os2Mbx();

  } // end constructor test()

  /******************************************************************
  * Method: handleEvent()
  ******************************************************************/
  public boolean handleEvent(Event evt)
  {

    switch(evt.id)
    {
      case Event.WINDOW_DESTROY: 
                   System.exit(0);
                   return false;
    } // endswitch

    if(evt.target instanceof Button)
    {
      String choice=(String)evt.arg;

      if(choice.equals("Test me!"))
      {
        int result;

        result=msg.show("sample1",
                        "Press 'Yes' or 'No'",
                        Os2Mbx.MB_YESNO |           // Define Buttons
                        Os2Mbx.MB_MOVEABLE |        // Define TitleBar
                        Os2Mbx.MB_ICONQUESTION      // Define Icon
                        );

        String response;
        switch(result)
          {
            case Os2Mbx.MBID_YES:
                        response=new String("Yes");
                        break;
            case Os2Mbx.MBID_NO:
                        response=new String("No");
                        break;
            default:
                        response=new String("Ouups!");
                        break;
          } // endswitch

          msg.showOk("Test Application",
                     "You pressed: "+response);

      } // endif
    } // endif

    return false;

  } // end method handleEvent()

} // end class sample1
