/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.quote;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import sunw.demo.quote.HttpProxy;
import sunw.demo.quote.PropertyPanel;
import sunw.demo.quote.QuoteServerApp;

class QuoteServerGUI
extends Frame {
    private QuoteServerApp quoteServerApp;
    private PropertyPanel propsPanel = new PropertyPanel();
    private static String sProxyHost = "HTTP Proxy Host";
    private static String sProxyPort = "HTTP Proxy Port";
    private static String sSource = "Quote Source";
    private static String sStatus = "Server Status";

    QuoteServerGUI(QuoteServerApp quoteServerApp) {
        this.quoteServerApp = quoteServerApp;
        this.setLayout(new BorderLayout());
        this.setTitle("QuoteServer");
        this.addWindowListener(new WindowEventHandler());
        this.propsPanel = new PropertyPanel();
        this.propsPanel.appendProperty(sProxyHost, "<unknown>");
        this.propsPanel.appendProperty(sProxyPort, "<unknown>");
        this.propsPanel.appendProperty(sSource, "Local");
        this.propsPanel.appendProperty(sStatus, "Iniitializing ...");
        this.propsPanel.addPropertyActionListener(sProxyHost, new ChangeProxyHost());
        this.propsPanel.addPropertyActionListener(sProxyPort, new ChangeProxyPort());
        this.propsPanel.addPropertyActionListener(sSource, new ChangeQuoteSource());
        this.propsPanel.setPropertyEditable(sProxyHost, true);
        this.propsPanel.setPropertyEditable(sProxyPort, true);
        this.propsPanel.setPropertyEditable(sSource, true);
        this.add("Center", this.propsPanel);
        this.pack();
    }

    void showStatus(String string) {
        this.propsPanel.setPropertyValue(sStatus, string);
    }

    void refreshAll() {
        try {
            HttpProxy httpProxy = QuoteServerApp.server.getHttpProxy();
            this.propsPanel.setPropertyValue(sProxyHost, httpProxy.getHost());
            this.propsPanel.setPropertyValue(sProxyPort, String.valueOf(httpProxy.getPort()));
            return;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return;
        }
    }

    void setHttpProxy() {
        try {
            String string = this.propsPanel.getPropertyValue(sProxyHost);
            String string2 = this.propsPanel.getPropertyValue(sProxyPort);
            HttpProxy httpProxy = new HttpProxy(string, Integer.valueOf(string2));
            QuoteServerApp.server.setHttpProxy(httpProxy);
            this.propsPanel.setPropertyValue(sStatus, "Ready");
            return;
        }
        catch (RemoteException remoteException) {
            this.propsPanel.setPropertyValue(sStatus, "Bad HTTP proxy host/port");
            return;
        }
    }

    class ChangeProxyHost
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            QuoteServerGUI.this.setHttpProxy();
        }

        ChangeProxyHost() {
            QuoteServerGUI.this = QuoteServerGUI.this;
        }
    }

    class ChangeProxyPort
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            QuoteServerGUI.this.setHttpProxy();
        }

        ChangeProxyPort() {
            QuoteServerGUI.this = QuoteServerGUI.this;
        }
    }

    class ChangeQuoteSource
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = QuoteServerGUI.this.propsPanel.getPropertyValue(sSource);
            if (string.equalsIgnoreCase("local")) {
                string = "Local";
            } else if (string.equalsIgnoreCase("yahoo")) {
                string = "Yahoo";
            } else {
                QuoteServerGUI.this.propsPanel.setPropertyValue(sStatus, "Source must be Local or Yahoo");
                string = null;
            }
            try {
                if (string != null) {
                    QuoteServerApp.server.setQuoteSource(string);
                    QuoteServerGUI.this.propsPanel.setPropertyValue(sSource, string);
                    QuoteServerGUI.this.propsPanel.setPropertyValue(sStatus, "Ready");
                    return;
                }
            }
            catch (RemoteException remoteException) {
                QuoteServerGUI.this.propsPanel.setPropertyValue(sStatus, "Set quote source failed!");
            }
        }

        ChangeQuoteSource() {
            QuoteServerGUI.this = QuoteServerGUI.this;
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }

        WindowEventHandler() {
            QuoteServerGUI.this = QuoteServerGUI.this;
        }
    }
}

