/* inst.cmd */

version = '2.8.1.1a'
patch = 'lwpatch'

call RxFuncAdd 'SysSearchPath', 'RexxUtil', 'SysSearchPath'

progs = 'gzip pax rm sed' patch
do i = 1 to words(progs)
  prog = word(progs, i)||'.exe'
  path = SysSearchPath('PATH', prog)
  if path == '' then
    error('Program not found: '||prog)
end
/* TODO: improve the test for OS/2's PATCH.EXE */
path = SysSearchPath('PATH', patch||'.exe')
if translate(filespec('p', path)) == '\OS2\' then
  error('Cannot use OS/2 version of PATCH.EXE')

usage = 0
parse arg cmdline

parse var cmdline first last rest

if first == '' then first = 1
if last == '' then last = 9999

if (rest \== '') | \datatype(first,'n') | \datatype(last,'n'),
   | (first > last) then do
  say 'Usage: inst [<start#> [<end#>]]'
  usage = 1
end

if \exists('patches\libgpp\inst.cmd') then
  error('The current working directory must be \emx\gnu')

'@echo off'

if usage then say 'Values for <start#> and <end#>:'

dir = 'libg++-'||version

if step(1, 'Unpacking libg++') then do
  if exists(dir) | dir_exists(dir) then error(dir||' exists')
  'gzip -d <libg++-'||version||'.tar.gz | pax -r -s!/Complex\.!/Complx.!p -s!/FileBuf\.!/FileBuff.!p -s!/Regex\.!/Regx.!p -s!/String\.!/Strng.!p'
  if rc \== 0 then error('pax failed')
end

if step(2, 'Removing the read-only flag') then do
  'attrib -r '||dir||'\* /s'
  if rc \== 0 then error('attrib failed')
end

if step(3, 'Deleting unused files') then do
  'cd' dir
  'cd libg++'
  'rm -r config etc gperf no-stream'
  'rm -r proto-kit utils vms'
  'rm ChangeLog Makefile.in README.SHLIB config.shared configure.in'
  'rm genclass/Makefile.in genclass/ChangeLog genclass/configure.in'
  'rm test-install/ChangeLog test-install/configure.in'
  'rm tests/ChangeLog tests/configure.in'
  'rm src/.cvsignore test-install/.cvsignore tests/.cvsignore'
  'cd ..\librx'
  'rm ChangeLog INSTALL INSTALL.rx configure configure.in Makefile.in'
  'cd ..\..'
end

if step(4, 'Configuring for emx') then do
  'cd' dir
  'sed -f ..\patches\libgpp\makefile.sed libg++\src\Makefile.in >libg++\src\Makefile'
  'copy ..\patches\libgpp\genclass.mak "libg++\genclass\Makefile"'
  'copy ..\patches\libgpp\genclass.c "libg++\genclass"'
  'copy ..\patches\libgpp\dirent.c "libg++\genclass"'
  'copy ..\patches\libgpp\dirent.h "libg++\genclass"'
  'cd ..'
end

if step(5, 'Applying emx patches') then do
  'cd' dir
  patch '-p1 <..\patches\libgpp\patches'
  'cd ..'
end

exit usage

/* Procedures */

exists:
  return stream(arg(1), 'c', 'query exists') \== ''

dir_exists: procedure
  cur = directory()
  new = directory(arg(1))
  call directory(cur)
  return new \= ''
  
step: procedure expose first last usage
  if usage then do
    say '  ' arg(1)||':' arg(2)
    return 0
  end
  if (first <= arg(1)) & (arg(1) <= last) then do
    say 'Step' arg(1)||':' arg(2)
    return 1
  end
  return 0

error:
  say '*** Error:' arg(1)
  exit 2
